//
//  UIFont+CustomFont.h
//  AntUI
//
//  Created by zhaolei on 2017/7/7.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
//读取开关是否回滚DINPro字段
BOOL AntUI_NumberFont_RollbackToDINPro();
//判断是否是数字字体
BOOL IsOfAliNumberFont(NSString* fontName);
//获得数字字体名字
NSString * AUNumberFontName();

//获得数字字体路径
NSString * AUNumberFontPath();

@interface UIFont(CustomFont)

+ (void)au_loadFontWithResource:(NSString *) resource;

//only for 鸟巢
+ (UIFont *) fontWithCustomName:(NSString *)customName size:(CGFloat) size;

//业务请调用这个
+ (UIFont *) au_fontWithCustomName:(NSString *) customName
                          size:(CGFloat) size;

/*
 * 不带Dinpro/AlipayNumber自动转化逻辑的
 * 除鸟巢外不要调用
 */
+ (UIFont *) au_fontWithCustomNameNoAutoConvert:(NSString *) customName
                          size:(CGFloat) size;

//for 鸟巢
+ (NSString *) au_numberFontName;

//返回对应的bold字体
- (UIFont *) au_setBoldFont:(BOOL) isBoldFont;



@end


//兼容性方法，给容器用，别的别用


//获得旧的数字字体路径
//不一定会有了
NSString * AUNumberV2FontName();

NSString * AUNumberV2FontPath();

//第三版本的数字字体

NSString * AUNumberV3FontName();

NSString * AUNumberV3FontPath();
//AUNumberOLDFontPath == AUNumberV3FontPath
NSString * AUNumberOLDFontPath();


@interface UIFont(AntUI)


/**
 获取HelveticaNeue字体

 @param fontSize 字体大小
 @return HelveticaNeue字体
 */
+ (UIFont *)au_getHelveticaNeueFont:(float)fontSize;


/**
 获取STHeitiSC-Light字体

 @param fontSize 字体大小
 @return STHeitiSC-Light字体
 */
+ (UIFont *)au_getHeitiSCFont:(float)fontSize;

@end
