//
//  AUV2SingleListItemView.h
//  AntUI
//
//  Created by Wang on 2020/4/14.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN


typedef NS_ENUM(NSUInteger,AUV2SingleListItemViewPosition)
{
    AUV2SingleListItemViewPositionTop, //上圆角
    AUV2SingleListItemViewPositionMiddle, //上分割线
    AUV2SingleListItemViewPositionBottom, //下圆角 + 上分割线
    AUV2SingleListItemViewPositionSingle //上下圆角
};

typedef NS_ENUM(NSUInteger,AUV2SingleListItemColorStyle)
{
    AUV2SingleListItemColorStyleCommon, //白底，前景色黑字
    AUV2SingleListItemColorStyleRevert //前景色白色，业务使用setBackgroundColor设置一下背景色。
};

typedef NS_ENUM(NSUInteger,AUV2SingleListItemHeightStyle)
{
    AUV2SingleListItemHeightStyleDefault,//96px高度
    AUV2SingleListItemHeightStyle88//88px高度
};


/**
 *
 * 布局：
 * |  iconImageView titleLabel  ----------------------------- descLabel badgeView  >  |
 */
@interface AUV2SingleListItemView<ParamType> : AUKControl<AUScalingModelSupport>

//主标题
@property (nonatomic,strong) AUIImageView *iconImageView;
@property (nonatomic,strong) UILabel *titleLabel;

//红点等
@property (nonatomic,strong) UIView *badgeView;

//右侧内容区等
@property (nonatomic,strong) UILabel *descLabel;

//业务扩展参数,设置点击响应的时候可以读取到。
@property (nonatomic,strong) ParamType param;

@property (nonatomic,assign) AUV2SingleListItemColorStyle colorStyle;
@property (nonatomic,assign) AUV2SingleListItemViewPosition position;
@property (nonatomic,assign) AUV2SingleListItemHeightStyle heightStyle;

//设置ContentCompressionResistance等，默认右侧Label优先级比较高。
@property (nonatomic,copy) void(^contentCompressionSetting)(AUV2SingleListItemView<ParamType> *item);
/**
 * 重设整个数据
 *
 */
-(void) loadData:( void(^)(AUV2SingleListItemView<ParamType> *item)) complete;

/**
 * 更新部分数据，主要是消除红点。
 *
 */
-(void) updateData:( void(^)(AUV2SingleListItemView<ParamType> *item))complete;



@end




NS_ASSUME_NONNULL_END
