//
//  AUThirdPartyDefine.h
//  AntUI
//
//  Created by maizhelun on 2017/3/31.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <AntUI/AUTPWrapper.h>

#ifndef AUThirdPartyDefine_h
#define AUThirdPartyDefine_h


/////////////////////////////////////////////////////////////
////////////////////// Language /////////////////////////////
/////////////////////////////////////////////////////////////

/**
 *  取当前语言版本的文本.
 *  @param bundle  文本在字符串表所在\c bundle名,通常为模块资源bundle名称.
 *  @param key     文本在字符串表中的key
 *  @param comment 当找不到\c key 对应的文本内容时, commont作为默认返回内容.同时 \c commont 也作为\c genstrings自动生成\c .strings文件时的注释.
 *
 *  @return 当前语言版本的文本内容. 若字符串表中没有该\c key, 返回 \c comment .
 */
#undef	__TEXT
#define __TEXT(bundle,key,comment) \
[AULanguageShell localizedStringForKey:(key) defaultValue:(comment) inBundle:(bundle)]

/////////////////////////////////////////////////////////////
////////////////////// Common /////////////////////////////
/////////////////////////////////////////////////////////////
#define kBEEAdjustHeight(height) height // APCommonUIGetScreenWidth()/350 * height

CG_INLINE BOOL AUIsKindOfClass(NSObject *object,NSString *isKindOfClassName)
{
    return NSClassFromString(isKindOfClassName) ? [object isKindOfClass:NSClassFromString(isKindOfClassName)] : NO;
}


/////////////////////////////////////////////////////////////
//////////////////////   RGB    /////////////////////////////
/////////////////////////////////////////////////////////////

#define RGB(c) \
[UIColor colorWithRed:(((c) & 0xff0000) >> 16) / 255.0f \
green:(((c) & 0xff00) >> 8) / 255.0f \
blue:((c) & 0xff) / 255.0f \
alpha:1.0]

#define RGB_A(c,a) \
[UIColor colorWithRed:(((c) & 0xff0000) >> 16) / 255.0f \
green:(((c) & 0xff00) >> 8) / 255.0f \
blue:((c) & 0xff) / 255.0f \
alpha:a]
//#define RGB(c) (AURGB(c))
//
//#define RGB_A(c,a) (AURGB_A(c,a))


/////////////////////////////////////////////////////////////
//////////////////////   MD5    /////////////////////////////
/////////////////////////////////////////////////////////////
//#define MD5String(text) [AUShell thirdParty_md5String:text];

/////////////////////////////////////////////////////////////
////////////////////  OpenURL  ///////////////////////////
/////////////////////////////////////////////////////////////

#define AUOpenURL(urlString) [AUShell thirdParty_openURL:(urlString)]


/////////////////////////////////////////////////////////////
////////////////////  AUActionSheet  ///////////////////////////
/////////////////////////////////////////////////////////////
#define kActionSheetBageStyleForTinyAppNone @"none"
#define kActionSheetBageStyleForTinyAppPoint @"point"
#define kActionSheetBageStyleForTinyAppNum @"num"
#define kActionSheetBageStyleForTinyAppText @"text"
#define kActionSheetBageStyleForTinyAppMore @"more"




/////////////////////////////////////////////////////////////
////////////////////  AUUIDefines  ///////////////////////////
/////////////////////////////////////////////////////////////

#define AUNavItemPreferedIconSize  (CGSizeMake(21,21))
#define AUCustomNavigationBarHeight (44)

/////////////////////////////////////////////////////////////
////////////////////  DEVICE  ///////////////////////////
/////////////////////////////////////////////////////////////

#define DEVICE_IS_IPHONE4 ([[UIScreen mainScreen] bounds].size.height == 480)
#define DEVICE_IS_IPHONE5 ([[UIScreen mainScreen] bounds].size.height == 568)
#define DEVICE_IS_IPHONE6 ([[UIScreen mainScreen] bounds].size.height == 667)
#define DEVICE_IS_IPHONE6Pluc ([[UIScreen mainScreen] bounds].size.height == 736)


#endif /* AUThirdPartyDefine_h */
