#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_Search_AUSearchController//程序自动生成
//
//  AUSearchDisplayViewController.h
//  AntUI
//
//  Created by niki on 16/11/22.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <AntUI/AUSearchBar.h>

#define UI_AUSearchController

@class AUSearchController;

//
@protocol AUSearchControllerDelegate <NSObject>

@optional
// 当展示/隐藏AUSearchControllerDelegate的回调
- (void)AUSearchControllerDelegateWillBeginSearch:(AUSearchController *)controller;
- (void)AUSearchControllerDelegateDidBeginSearch:(AUSearchController *)controller;
- (void)AUSearchControllerDelegateWillEndSearch:(AUSearchController *)controller;
- (void)AUSearchControllerDelegateDidEndSearch:(AUSearchController *)controller;

// 点击蒙层
//- (void)didClickMaskView:(AUSearchController *)searchController;

@end


//
@interface AUSearchController : NSObject

@property(nonatomic, weak) id<AUSearchControllerDelegate>              delegate;
@property(nonatomic, getter=isActive) BOOL                          active;                     // 是否可点击，当正在搜索时或者动画过程中，默认为不可点击
@property(nonatomic, readonly) AUSearchBar                          *searchBar;                 // 包含的seacherBar
@property(nonatomic, weak, readonly) UIViewController               *searchResultsController;  // searchController的宿主VC (通常是 UITableViewController)
@property(nonatomic, readonly) UITableView                          *searchResultsTableView;    // 搜索结果的tableView，默认会返回一个，需要的话可以自定义
@property(nonatomic, strong) UIView                                 *customSearchContentView;   // 自定义的内容区域view，取代dimmingview,默认是nil，业务根据需要来设置赋值
@property(nonatomic, assign) BOOL navigationbarHiddenMode;      // 手动隐藏navigationbar的场景, 需要设置为YES, 否则会多出一个navigationbar
@property(nonatomic, assign) BOOL newAlphaAnimation;     // 渐隐动画
@property(nonatomic, assign) UIEdgeInsets                          searchResultsTableViewInsets ;
/*
 *  初始化一个APAUSearchControllerDelegate
 *
 *  @param searchBar      创建的searchBar
 *  @param viewController 展示结果的VC
 *
 *  @return APAUSearchControllerDelegate
 */
- (id)initWithSearchBar:(AUSearchBar *)searchBar searchResultsController:(UIViewController *)viewController;

- (void)setActive:(BOOL)active animated:(BOOL)animated; // animate the view controller for searching

/*
*  初始化一个APAUSearchControllerDelegate
*
*  @param active      创建的searchBar
*  @param animated    是否动画
*  @param isSilence   是否静默，如果静默则意味着当前searchController实例被激活时仍然保留导航栏，不会出现从searchbar normal页面动画唤起searchController的情况
*  @return APAUSearchControllerDelegate
*/
- (void)setActiveInSilenceMode:(BOOL)active;

- (void)handleTap;

@end

#endif//程序自动生成
