//
//  AURightBarButtonsBox.h
//  AntUI
//
//  Created by Wang on 2020/5/28.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN



@interface AURightBarButton : AUKControl

@property (nonatomic,strong) UIView *contentView;
@property (nonatomic,strong) UIView *extraView;
@property (nonatomic,strong,readonly) NSArray *contentViewList;
@property (nonatomic,assign,readonly) NSInteger index;
@property (nonatomic,copy) void(^barButtonHighlightedHandler)(AURightBarButton *button,BOOL isHighlight);

@property (nonatomic,strong) NSString *badgeNumber;

-(void) setContentView:(UIView *)view forState:(UIControlState)state;

-(void) onClicked;

@end

@interface AUV2NavItemView : AURightBarButton


@property (nonatomic,strong) UIImage *nomarlStateIconImage;

@property (nonatomic,strong) NSString *iconfontIdendifier;

@property (nonatomic,strong) NSString *voiceOverText;



-(void) setIconfontColor:(UIColor*)color forState:(UIControlState)state;


-(void) onClicked;

@end


@interface AUV2NavLabelItemView : AURightBarButton

@end



@interface AURightBarButtonsBox : UIView

@property (nonatomic,strong,readonly) NSArray<AURightBarButton*> *contentViewArray;

-(AURightBarButton *) addIconFontItem:(NSString *)kIconfont
                              color:(UIColor *)color
                              setting:(void (^)(AURightBarButton*))setting clickBlock:(void(^)(AURightBarButton *s))block;


-(AURightBarButton *) addTextItem:(NSString *)text
                              color:(UIColor *)color
                              setting:(void (^)(AURightBarButton*))setting clickBlock:(void(^)(AURightBarButton *s))block;

/**
 *
 *class 必须实现AURightBarButtonProtocol协议
 */
-(AURightBarButton *) addNavigationItem:(NSString *)clsName;


-(AURightBarButton *) insertNavigationItem:(NSString *)clsName atIndex:(NSInteger)index;



/**
*@param customView:自定义View，设置进来之前先定好width/Height
*@return 返回View的下标
*/
-(NSInteger) addNavigationCustomView:(UIView *)customView;


/**
 *@param customView:自定义View，设置进来之前先定好width/Height
 *@param index:位置
 *@return 返回View的下标
 *
 *@note: insert的注意事项等同于NSMutableArray: insertObject:atIndex:
 */
-(NSInteger) insertNavigationCustomView:(UIView *)customView atIndex:(NSInteger)index;

/**
 * @param index,需要删除的下标
 * @return 返回移除的下标，如果没有变化，返回NSNotFound
 */
-(NSInteger) removeNavigationCustomView:(UIView *)customView;


/**
* @param view,判断是否存在
* @return 如果能找到返回Index，如果找不到返回NSNotFound
*/
-(NSInteger) indexOfNavigationView:(UIView*)view;

/**
 *
 *移除一个View
 *@return 返回移除的下标，如果没有变化，返回NSNotFound
 */
-(NSInteger) removeNavigationItem:(NSString *)clsName;

-(void) updateItemAtIndex:(NSInteger) index block:( void(^)(AURightBarButton *))block;
@end

NS_ASSUME_NONNULL_END
