//
//  AURichLabel.h
//  AntUI
//
//  Created by niki on 2019/4/19.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol AURichLabelDelegate <NSObject>

- (void)getImageWithURL:(NSString *)url completion:(void (^)(UIImage *image))completion;

@end

// 
@interface AURichLabel : UIView

@property (nonatomic, weak) id<AURichLabelDelegate> delegate;

- (instancetype)initWithFrame:(CGRect)frame cssStyle:(NSDictionary *)styles;

// 设置富文本字符串
- (void)setHTMLString:(NSString *)htmlStr;

// 定制化UI样式
- (void)updateWithCssStyle:(NSString *)cssStyle;

+ (CGSize)getSizeWithHtml:(NSString *)htmlStr preferMaxSize:(CGSize)preferMaxSize;

//- (instancetype)initWithFrame:(CGRect)frame htmlStr:(NSString *)htmlStr;

@end

NS_ASSUME_NONNULL_END
