//
//  AURefreshAnimationView.h
//  AntUI
//
//  Created by niki on 2020/4/20.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN


typedef NS_ENUM(NSUInteger, AURefreshAnimationType) {
    AURefreshAnimationTypeDefault,       // 全动画模式
    AURefreshAnimationTypeSection1,      // 部分动画模式，只涵盖0-45循环，播放到第45帧后自动从0开始循环
    AURefreshAnimationTypeLoading        // Loading的动画
};

typedef NS_ENUM(NSUInteger, AURefreshAnimationStyle) {
    AURefreshAnimationStyleDefault,       // 蓝色样式,RGB(0x999999);
    AURefreshAnimationStyleFeature1,      // 白色样式,RGB_A(0xFFFFFF,0.6);
    AURefreshAnimationStyleFeature2,      // 灰色样式,RGB_A(0xCCCCCC,0.6);
    AURefreshAnimationStyleCustom,        // 自定义前景色
    AURefreshAntMationStyleDefault = AURefreshAnimationStyleDefault,       // AntMation 蓝色样式
    AURefreshAntMationStyleFeature1 = AURefreshAnimationStyleFeature1,      // AntMation 白色样式
    AURefreshAntMationStyleFeature2 = AURefreshAnimationStyleFeature2,      // AntMation 灰色样式,RGB_A(0xCCCCCC,0.6);
    //AURefreshAnimationStyleUnify        // 0x000,0.2
};

UIColor *AURefreshColorByStyle(AURefreshAnimationStyle style);

// 支付宝统一下拉刷新，1-40循环，40-51回弹完成，51-68下拉，688阈值，68-84过度
@interface AURefreshAnimationView : UIView

//可以自定义前景色。
//必须使用AURefreshAnimationStyleCustom
@property (nonatomic,strong) UIColor * foregroundColor;

//
@property (nonatomic, strong) NSString *bizType;

// 同步加载Lottie json资源
- (instancetype)initWithType:(AURefreshAnimationType)type
                       style:(AURefreshAnimationStyle)style;


// 同步加载Lottie json资源
- (instancetype)initWithType:(AURefreshAnimationType)type
                       style:(AURefreshAnimationStyle)style
                       foregroundColor:(UIColor*)color;

// 开始播放并自动循环
- (void)playAnimation;

// 停止当前
- (void)stopAnimation;

//
- (void)pauseAnimation;
    
// 是否正在动画
- (BOOL)isAnimating;

/*
 * 手工设置进度。
 * 会暂停动画，停在特定的进度上。
 */
- (void) updateProgress:(CGFloat)progress;

@end


// 1-40循环，40-51回弹完成，51-68下拉，688阈值，68-84过度

#define     AntRefreshLoopStartFrame                [AntRefreshFrameModel AURefreshLoopStartFrame]      // 统一刷新动画循环起始帧
#define     AntRefreshLoopEndFrame                  [AntRefreshFrameModel AURefreshLoopEndFrame]        // 统一刷新动画循环结束帧
#define     AntRefreshCloseStartFrame               [AntRefreshFrameModel AURefreshCloseStartFrame]     // 统一刷新页面回弹动画起始帧
#define     AntRefreshCloseEndFrame                 [AntRefreshFrameModel AURefreshCloseEndFrame]       // 统一刷新页面回弹动画结束帧
#define     AntRefreshPullStartFrame                [AntRefreshFrameModel AURefreshPullStartFrame]      // 统一刷新下拉起始帧
#define     AntRefreshPullEndFrame                  [AntRefreshFrameModel AURefreshPullEndFrame]        // 统一刷新下拉阈值
#define     AntRefreshTransitionalStartFrame        [AntRefreshFrameModel AURefreshTransitionalStartFrame]  // 统一刷新过度动画起始帧
#define     AntRefreshTransitionalEndFrame          [AntRefreshFrameModel AURefreshTransitionalEndFrame]  // 统一刷新过度动画结束帧
#define     AntRefreshCloseBeforeFadeEndFrame       ([AntRefreshFrameModel AURefreshCloseEndFrame] - 10)       // 统一刷新页面回弹动画透明前

// 主要用在下拉刷新场景
@interface AURefreshAnimationView (AUAnimationTypeDefault)

// 异步加载Lottie刷新视图
- (instancetype)initWithStyle:(AURefreshAnimationStyle)style
                      bizType:(NSString *)bizType
         LottieLoadCompletion:(void(^)(AURefreshAnimationView *lottieView, NSError *error))completion;

// 支持设置展位图的
- (instancetype)initWithPlaceholder:(nullable UIView *)placeholder
                              style:(AURefreshAnimationStyle)style
               lottieLoadCompletion:(void(^)(AURefreshAnimationView *lottieView, NSError *error))completion;

//
- (void)startAnimationFromFrame:(NSNumber *)startFrame toFrame:(NSNumber *)toFrame completion:(void (^)(BOOL animationFinished))completion;

// 设置当前帧数
- (void)setAnimationFrame:(NSNumber *)frame;

// 获取当前帧数
- (NSNumber *)getCurrentFrame;

// 获取总帧数
- (NSNumber *)getTotalFrame;

//
- (void)setLoopAnimation:(BOOL)loop;

//
- (BOOL)isLoopAnimation;

@end


@interface AntRefreshFrameModel : NSObject
+ (CGFloat)AURefreshLoopStartFrame;
+ (CGFloat)AURefreshLoopEndFrame;
+ (CGFloat)AURefreshCloseStartFrame;
+ (CGFloat)AURefreshCloseEndFrame;
+ (CGFloat)AURefreshPullStartFrame;
+ (CGFloat)AURefreshPullEndFrame;
+ (CGFloat)AURefreshTransitionalStartFrame;
+ (CGFloat)AURefreshTransitionalEndFrame;

@end

NS_ASSUME_NONNULL_END



