#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_PopTip//程序自动生成
//
//  AUPopDrawBoardView.h
//  AntUI
//
//  Created by 沫竹 on 2018/3/15.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <AntUI/AntUI.h>

typedef NS_ENUM(NSInteger, AUPopViewIndicatorDirection) {
    AUPopViewIndicatorDirectionUp,
    AUPopViewIndicatorDirectionDown,
    AUPopViewIndicatorDirectionNone,
    AUPopViewIndicatorDirectionLeft//向左
};

typedef NS_ENUM(NSInteger, AUPopViewOriginType) {
    AUPopViewOriginTypeTop,
    AUPopViewOriginTypeBottom
};

@interface AUPopDrawBoardView : AUView

@property (nonatomic,strong) UIColor * triangleBorderColor;

@property (nonatomic, strong) UIView *customView;

//尽可能往右边移，最大箭头和左边32px;
//@property (nonatomic, assign) BOOL customlizedMoveRightIfNeeded;

//距离左边剧最小的距离
@property (nonatomic, assign) CGFloat customlizedMiniMarginLeft;

//距离右边剧最小的距离
@property (nonatomic, assign) CGFloat customlizedMiniMarginRight;

// 相对toView的距离
@property (nonatomic, assign) CGFloat toViewhorizonMargin;

//dismiss的时候回去执行代码
@property (nonatomic, copy) void (^actionOnDismiss)();


-(CGFloat) marginLeft;
-(CGFloat) marginRight;

@property (nonatomic, strong) UIColor *maskViewBackgroundColor;

/**
 * 点击contentView时会执行的代码
 * 当设置d之后，不会自动dismiss，需要业务来调用
 */
@property (nonatomic, copy) void(^contentViewDidClicked)(AUPopDrawBoardView *view);

/**
 * 业务标示
 *
 */
@property (nonatomic, strong) NSString *bizId;


- (void)dismiss:(BOOL)animated;

@property (nonatomic, assign) AUPopViewIndicatorDirection indicatorDirection;

//箭头的背景色，如果没有设置，使用customView的背景色，如果也没有，则使用默认颜色
@property (nonatomic, strong) UIColor *arrowBackgroundColor;


- (instancetype)initWithCustomView:(UIView *)customView;

- (void)showFromView:(UIView *)fromView
           fromPoint:(CGPoint)fromPoint
              toView:(UIView *)toView;

- (void)showFromView:(UIView *)fromView
           fromPoint:(CGPoint)fromPoint
              toView:(UIView *)toView
            animated:(BOOL) animated;

- (void)showAtOrigin:(CGPoint)origin
              inView:(UIView *)view
           direction:(AUPopViewIndicatorDirection)direction;

/**
 *@param origin, 展示的坐标位置
 *@param originType, origin的定位方式，如果为top说明是左上距离view top的距离，如果是bottom说明是左下距离view底部的位置
 *@param view, 控件被添加到的view
 *@param direction, 三角形的方向
 */
- (void)showAtOrigin:(CGPoint)origin
          originType:(AUPopViewOriginType)originType
              inView:(UIView *)view
           direction:(AUPopViewIndicatorDirection)direction;


- (void) updateFrameFromCustomView;

- (void) showAgain;
/**
 是否启用遮罩视图A
 1、启用遮罩视图会在toView上增加一层遮罩视图，当用户触摸这个遮罩视图时，会将本视图消失
 2、创建本视图时，默认是带有遮罩视图的，可以调用此方法将遮罩视图去掉
 
 @param enable YES，是；NO，不是
 */
- (void)enableMaskView:(BOOL)enable;

- (void)enableMaskView:(BOOL)enable disablePassEvent:(BOOL) disablePassEvent;

- (void)enableMaskView:(BOOL)enable customMaskHiddenBlock:( void(^)(AUView *))block forceShowOnSuperview:(BOOL)forceShow;
//子类实现，弹框uep上报的参数
-(NSDictionary *)_getUEPExposureEventContext;

@end


#endif//程序自动生成
