//
//  AUNavigationConstants.h
//  AntUI
//
//  Created by niki on 2019/1/9.
//  Copyright © 2019年 Alipay. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 *  获取导航栏上返回按钮返回箭头调整单位值
 */
CGFloat AUBackButtonImageFixedSpace();

/**
 *  获取导航栏上返回按钮距离设备的间距
 */
CGFloat AUGetBackButtonToDeviceSpace();

/**
 *
 * 根据当前Controller的情况返回按钮距离
 */
CGFloat AUGetBackButtonToDeviceSpaceForController(UIViewController *controller);


/**
 *  获取导航栏上获取titleView与返回箭头的最小间距
 */
CGFloat AUGetTitleViewToBackBtnMinSpace();

/**
 *  获取导航栏上获取titleView与设备边沿的最小间距，用于没有返回箭头时的场景
 */
CGFloat AUGetTitleViewToDeviceMinSpace();

/**
 * 获取导航栏右上角最右侧边距
 */
CGFloat AUGetRightBarItemRightMargin();


/**
 * 获取导航栏右上角最左侧边距
 */
CGFloat AUGetRightBarItemLeftMargin();

/**
 * 获取导航栏右上角按钮大小
 */
CGSize AUGetRightBarItemSize();

/**
 * 获取导航栏右上角水平间距
 */
CGFloat AUGetRightBarItemHorizontalSpace();

/**
 * 浅色背景下默认前景色
 * RGB(0x333333);
 *
 */
UIColor *AURightBarButtonDefaultColor();


/**
 * 深色色背景下默认前景色
 * RGB(0xFFFFFF);
 *
 */
UIColor *AURightBarButtonDarkDefaultColor();


NS_ASSUME_NONNULL_END
