#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_refreshLoadingView_AULoadingView//程序自动生成
//
//  AULoadingView.h
//  AntUI
//
//  Created by 祝威 on 16/10/10.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>


//#########################################################
//文档地址 : https://yuque.antfin-inc.com/antui/auidoc/ios_auloadingview
//#########################################################

/**
 *
 * 等待组件
 *  布局：
 *  ｜ ------------------------  AUILoadingIndicatorView ------ UILabel ---------------------------|
 * 调用方法
 *    #1 定宽动态高度
 *  AUV2LoadingView *loadView = [[AUV2LoadingView alloc]init];
 *  [loadingView2 setMaxWidth:AUCommonUIGetScreenWidthForPortrait() - 20];
 *    # 2 定Frame，动态边距
 *  AUV2LoadingView *loadView = [[AUV2LoadingView alloc]initWithFrame:CGRectMake(0,0,320,100);
 *
 *  loadingView2.x = 10;
    [loadingView2 updateData:^(AUV2LoadingView *s) {
     s.indicatorView.hidden = NO;
     s.textLabel.text = @"11111";
    }];
     
     loadingView2.top = self.loadingView.bottom + 20;
     [loadingView2 sizeToFit];

     [self.contentView addSubview:loadingView2];
 */

typedef NS_ENUM(NSInteger,AUV2LoadingLayoutType) {
    AUV2LoadingLayoutTypeLeftRight, //文本和等待条左右分布
    AUV2LoadingLayoutTypeTopDown //上下分布
};

typedef NS_ENUM(NSInteger,AUV2LoadingType) {
    AUV2LoadingTypePart , //页面部分用的
    AUV2LoadingTypeFull , //整页面的，见https://yuque.antfin.com/docs/share/a0eb437f-7333-4119-a7e7-60d2625bd9ec?# 《10.2.8 Native 组件迭代优化》
};

@interface AUV2LoadingView : UIView

@property (nonatomic,strong) AUILoadingIndicatorView *indicatorView;
@property (nonatomic,strong) UILabel *textLabel;
@property (nonatomic,assign) AUV2LoadingType type;

@property (nonatomic,assign) AUV2LoadingLayoutType layoutType;

-(void) setMaxWidth : (CGFloat) maxWidth;

-(void) updateData:( void(^)(AUV2LoadingView *))block;

@end


#define UI_AULoadingView

@class AUCircleProgressView;
/**
  中间加载的loading控件中间含数字
 */
@interface AULoadingView : UIView


@property (nonatomic,strong) AUCircleProgressView * loadingView;
@property (nonatomic,strong) UILabel * loadingSubTextLabel;
@property (nonatomic,strong) UILabel * loadingTextLabel;

@property (nonatomic,assign) BOOL isShowProgressPer; //是否显示进度百分比默认为NO
@property (nonatomic,assign) BOOL isShowLoadingText; //是否显示加载文案默认为NO


/**
  设置进度百分比

 @param progress 百分比的值
 */
- (void) setProgressPer:(CGFloat) progress;


@end

#endif//程序自动生成
