#import <AntUI/AUUILoadDefine.h>
//
//  AUFeedbackCellView.h
//  AntUI
//
//  Created by zibai on 2021/9/7.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUFeedbackCellDataModel.h>

@class AUFeedbackCellView;
@protocol AUFeedbackCellDelegate <NSObject>

@optional
/**
 *  点击事件回调
 *
 *  @param dataModel 点击的view对应的数据模型
 *  @param indexPath 点击的view在CellDataModel中的下标(若 CellDataModel.buttonsArray == nil ,则 row 默认取值为 -1)
 */
- (void)DidClickCellView:(AUFeedbackCellDataModel *)dataModel ForRowAtIndex:(NSInteger)index;
- (void)DidClickCellButton:(AUFeedbackCellDataModel *)dataModel ForRowAtIndexpath:(NSIndexPath *)indexPath;

/// 负反馈消失
/// @param clickMaskView  是否点了空白背景消失
- (void)DidDismissCellView:(AUFeedbackCellView *)feedbackCellView clickMaskView:(BOOL)clickMaskView;

@end


/**
 *  负反馈的cellview
 *  1. 图标 + 主标题
 *  2. 图标 + 主标题 + 多行多列的按钮控件
 */

@interface AUFeedbackCellView : UIView

@property (nonatomic, weak) AUFeedbackMenu* feedbackMenu;
@property (nonatomic, weak) id<AUFeedbackCellDelegate> delegate;
@property (nonatomic, strong) NSArray *cellDataArray;

// 如果cellDataArray为空等同于调用 initWithFrame 方法
- (instancetype)initWithFrame:(CGRect)frame
                cellDataArray:(NSArray *)cellDataArray;

- (void)exposureEventState:(AUKExposureState)state;

@end

@interface AUFeedbackButtonPanel : UIView
{
    NSArray *_buttonArray;
}
@property(nonatomic, strong)AUFeedbackCellDataModel* model;
@property(nonatomic, assign)NSInteger cellViewIndex;
@property(nonatomic, assign)BOOL mutilLevelPage_Rollback;
- (instancetype)initWithFrame:(CGRect)frame  model:(AUFeedbackCellDataModel *)model cellViewIndex:(NSInteger)cellViewIndex mutilLevelPage_Rollback:(BOOL)mutilLevelPage_Rollback;

@end


@class AUIconView;
/**
 *  图标 + 主标题 + 位于主标题下方的副标题 的cellView
 */

@interface AUFeedbackHeaderCellView : UIControl

@property (nonatomic, strong) AUIconView *iconImg;
@property (nonatomic, strong) UIButton *iconBtn;//透明按钮
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, assign) BOOL hightlightState;

- (instancetype)initWithFrame:(CGRect)frame dataModel:(AUFeedbackCellDataModel *)model;

@end
