#import <AntUI/AUUILoadDefine.h>
//
//  AUDialogWindow.h
//  AntUI
//
//  Created by QiXin on 2016/9/27.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

// 只有小程序业务才生效: 1表示只有小程序业务生效  0则表示全部回滚
//#define au_auto_orientation_tinyapp  ([[AUConfigShell configForKey:@"au_auto_orientation_state"] isEqualToString:@"1"])

// 弹窗屏幕旋转全部回滚
#define au_auto_orientation_revert   ([[AUConfigShell configForKey:@"au_auto_orientation_state"] isEqualToString:@"0"])


@class AUDialogViewController;
UIWindowLevel AUDialogWindowLevel();

typedef NS_ENUM(NSUInteger,AUDialogType)
{
    AUDialogTypeCommon, //普通弹窗
    AUDialogTypeBottomUp, //从底向上弹出
};

void AUIPrintDialogInfo(NSObject *view,NSString *format, ...);

@protocol AUDialogWindowViewProtocol <NSObject,NSCoding>

@property (nonatomic, assign) CGFloat    animationDuration;
@property (nonatomic, assign) BOOL    backgroundMark;
@property (nonatomic, weak) id    delegate;

@required
// 如何定位位置和布局
- (void) applyShowInView:(UIView *)view;

// 如何展示动画
- (void) applyShowAnimation;

// 如何展示隐藏动画
- (void) applyDismissAnimationWithBlock:(void(^)()) animation complete:(void (^)())complete;

@optional

//- (void) applyAnimationForBottomUp:(BOOL)isShow complete:( void(^)(BOOL complete))complete;

- (void)forceHidden;
- (UIView *)alertContainer; // autolayout需提供此参数
- (AUDialogType) dialogType;

@property (nonatomic, assign) BOOL    useUnifyShowAnimation;
@property (nonatomic, weak) UIViewController *viewController; // 当前dialog所在的页面
@property (nonatomic, strong) NSString *appId; // 当前dialog所在的页面
@property (nonatomic, assign) BOOL canceledOnTouchOutside;
//- (void)transformToOrientation_au:(UIInterfaceOrientation)toOrientation;
-(void) performAnimationForShow:(BOOL) isShow complete:(void(^)(BOOL complete))complete;

@end

@class AUDialogBaseView;
@interface AUDialogWindow : UIWindow

@property (nonatomic, assign) BOOL haveConfigWindowState;

- (void)configWindowStateDialog:(id<AUDialogWindowViewProtocol>)dialog;
- (void)applyShowDialog:(id<AUDialogWindowViewProtocol>)dialog;
- (AUDialogViewController *)dialogViewController;

+ (instancetype)window;

+ (BOOL)dialogWindowShowing;

- (void)showDialogView:(id<AUDialogWindowViewProtocol>)dialog logParams:(NSDictionary *)params;

- (void)dismissDialogView:(id<AUDialogWindowViewProtocol>)dialog logParams:(NSDictionary *)params  completion:(dispatch_block_t)completion;

- (void)dismissAllDialogView;

- (void)hideDialogInBackground;

- (void)showDialogEnterForground;

@end


@interface AUDialogViewController : UIViewController

@property (nonatomic, strong, readonly) UIView *dimmingBackground;
//@property (nonatomic, assign) BOOL    isSupportAutorotate;          // 设置是否需要支持屏幕旋转，默认不支持
@property (nonatomic,weak) UIWindow *previousKeyWindow;


@end




