#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_alert//程序自动生成
//
//  AUDialogBuilder.h
//  AntUI
//
//  Created by QiXin on 2016/9/21.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUEdge.h>
#import <AntUI/AUDialogWindow.h>
#import <AntUIKit/AntUIKit.h>
typedef NS_ENUM(NSInteger, AUDialogActionStyle) {
    AUDialogActionStyleDefault = 0, //普通按钮
    AUDialogActionStyleCancel = 1, //取消
    AUDialogActionStyleDestructive = AUDialogActionStyleDefault,
    AUDialogActionStyleWarning = 3, //红色警示
    AUDialogActionStyleCustom = 4, //自己设置
    
    AUDialogActionPropertyKeepNormalOnMainButton = 64//作为首按钮时要不要加粗，默认需要。
};

AUDialogActionStyle AUDialogActionForStyle(AUDialogActionStyle style);

typedef NS_ENUM(NSInteger, AUDialogBuilderType) {
    AUDialogBuilderType_Normal = 0,
    //AUDialogBuilderType_List, //
    AUDialogBuilderType_Input = 2, //
    AUDialogBuilderType_ImageNormal = 3, //图片尺寸280px * 280px
    AUDialogBuilderType_ImageAction = 4, //图片尺寸280px * 280px
    AUDialogBuilderType_operationResult = 5,
    AUDialogBuilderType_Custom_Normal = 6,
    //AUDialogBuilderType_Custom_List,
    AUDialogBuilderType_Custom_Input = 8,
    AUDialogBuilderType_Custom_ImageNormal = 9,
    AUDialogBuilderType_Large_Image = 10,
    AUDialogBuilderType_Custom_Normal_WithCloseBtn = 11,
    AUDialogBuilderType_Signal_Larage_Image = 12,
    //AUDialogBuilderType_Custom_Large_Image
};
typedef NS_ENUM(NSUInteger, AUDialogButtonPositionType)
{
    AUDialogButtonPositionTypeOutsideContent, //按钮在内容区外面
    AUDialogButtonPositionTypeInsideContent //按钮在内容区里面
};

@class AUDialogButton;

typedef NS_ENUM(NSUInteger,AUDialogButtonAssignment)
{
    AUDialogButtonAssignmentAuto,
    AUDialogButtonAssignmentHorizontalIfNeed,
    AUDialogButtonAssignmentVertical //强制上下排布
};
@interface AUDialogBuilder : NSObject
@property (nonatomic, weak) id dialogView;
@property (nonatomic, strong) NSString *title;

@property (nonatomic, strong) NSString *message;
@property (nonatomic, strong) NSAttributedString *attributedMessage;
@property (nonatomic, strong) NSString *richMessage;

@property (nonatomic, strong) UIImage  *image;
@property (nonatomic, strong) NSString *linkText;
@property (nonatomic, strong) NSString *placeholder;

@property (nonatomic, assign) BOOL      grayMessage;
@property (nonatomic, assign) CGSize    imageSize;

@property (nonatomic, strong) UILabel        *titleLabel;
@property (nonatomic, strong) UILabel        *messageLabel;

@property (nonatomic, strong) UIImageView    *imageView;
@property (nonatomic, strong) UITextField    *textField;
@property (nonatomic, strong) AUDialogButton *closeButton;
@property (nonatomic, strong) AUDialogButton *linkButton;
@property (nonatomic, strong) UIView *customView;   // 自定义内容区域
@property (nonatomic, strong) AUEdge *edge;    // 自定义内容区域边距
@property (nonatomic, strong) UIColor *closeBtnColor; // 右上角叉叉按钮的自定义色值

@property (nonatomic, assign) AUDialogBuilderType builderType;
//@property (nonatomic, assign) BOOL listButtonOrderFromBottom; // 是否从底部开始布局第一个按钮（默认从顶部开始）
@property (nonatomic, assign) BOOL horizontalButtonsIfNeeded;
@property (nonatomic, assign) AUDialogButtonAssignment buttonAssignment;
@property (nonatomic, assign) AUDialogType dialogType;
@property (nonatomic, assign) AUDialogButtonPositionType buttonPostionType;

@property (nonatomic, assign) NSTextAlignment messageTextAlignment;
@property (nonatomic, assign) NSLineBreakMode messageLineBreakMode;

@property (nonatomic, assign) CGFloat buttonViewHeight;
@property (nonatomic, assign) CGFloat maxHeight; //内容区域最大高度

@property (nonatomic, assign) BOOL disableAutoSetCancelButton;

- (void)addButton:(AUDialogButton *)button;
- (void)addButton:(AUDialogButton *)button actionStyle:(AUDialogActionStyle)style;
- (void)enableButton:(BOOL)enable atIndex:(NSInteger)index;

- (void)setLinkActionBlock:(BOOL (^)(NSString *))linkActionBlock;

- (void)buildAlertContentView:(UIView *)contentView dialogType:(AUDialogType) dialogType;
- (void)buildAlertButtonView:(UIView *)buttonView
              containerWidth:(CGFloat)containerWidth;

- (void)buildAlertButtonView:(UIView *)buttionView forDialogType:(AUDialogType) type;


- (void)updateTitleLayout;
- (void)updateMessageLayout;
- (void)updateTitleMesgUI;

- (nullable NSString *)buttonTitleAtIndex:(NSInteger)buttonIndex;

- (void) setupButtonTitleColor:(nullable UIColor *)color atIndex:(NSInteger)buttonIndex;
- (nullable UIButton *)buttonAtIndex:(NSInteger)buttonIndex;
@property(nonatomic,readonly) NSInteger numberOfButtons;


/// 为支持UEP埋点需求 @觉武 https://yuque.antfin-inc.com/docs/share/91bc6868-4225-4918-9a84-483027d9e37d?#
/// https://yuque.antfin-inc.com/docs/share/2f916b1d-7a34-4b64-8ffe-318001b9fae4?#myen3
@property (nonatomic, readonly) NSArray *buttonTitles;

-(void)executeUEPAllButtonExposureEvent:(AUKExposureState)state;


@end

#endif//程序自动生成
