#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_alert//程序自动生成
//
//  AUDialogBaseView.h
//  AntUI
//
//  Created by QiXin on 2016/9/20.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUDialogButton.h>
#import <AntUI/AUDialogProtocol.h>
#import <AntUI/AUDialogWindow.h>

extern NSString * kDialogShowAnimationKey;
extern NSInteger  kDialogForceDismissIndex;    // dialog强行dissmiss(如dismissAll方法调用时)的回调index

@class AUDialogBuilder;
@protocol AUUEPSupport;
@interface AUDialogBaseView : UIView<AUUEPSupport> {
    @package
    AUDialogBuilder *_dialogBuilder;
    NSInteger        _cancelIndex;
}

@property (nonatomic, weak) id<AUDialogDelegate> delegate;
@property (nonatomic, assign) NSTimeInterval animationDuration;
@property (nonatomic, strong) UIView *alertContainer;
@property (nonatomic, strong) UIScrollView *alertScrollView; // 内容超出屏幕范围支持滚动展示
@property (nonatomic, strong) UIView *contentView;
@property (nonatomic, strong) UIView *buttonView;
@property (nonatomic, strong) UIView *bottomView;

@property (nonatomic, assign, readonly) BOOL isDisplay;
@property (nonatomic, assign) BOOL    backgroundMark;
//@property (nonatomic, assign) BOOL listButtonOrderFromBottom; // 是否从底部开始布局第一个按钮（默认从顶部开始）
@property (nonatomic, assign) BOOL horizontalButtonsIfNeeded;

@property (nonatomic, assign) BOOL    grayMessage;
@property (nonatomic, assign) BOOL    useUnifyShowAnimation;
//@property (nonatomic, assign) BOOL    isSupportAutorotate __attribute__((unavailable("已废弃，若要支持屏幕旋转请使用viewController")));          // 设置是否需要支持屏幕旋转，默认不支持
@property (nonatomic, assign) NSTextAlignment messageAlignment;
@property (nonatomic, assign) NSLineBreakMode messageLineBreakMode;


@property (nonatomic, strong) NSString *title;
@property (nonatomic, strong) NSString *message;
@property (nonatomic, weak) UIViewController *viewController; // 当前dialog所在的页面，主要绑定弹窗与VC，确保弹窗与VC实例的方向保持一致，不传则默认取DTContext返回的visibleVC（第一期）
@property (nonatomic, strong, readonly) NSString *appId;

@property (nonatomic, assign) AUDialogButtonAssignment buttonAssignment;
@property (nonatomic, assign) AUDialogButtonPositionType buttonPostionType;



//自定义WindowLevel，一般业务不需要设置
@property (nonatomic, strong) NSNumber *customWindowLevel;

//目前AUDialogTypeBottomUp只支持initWithCustomView:的，别的还没支持
@property (nonatomic, assign) AUDialogType dialogType;

//点击Dialog外部是否要消失
//如果设置为YES，消失 之后会回调onCanceledTouchOutsideClicked:
@property (nonatomic, assign) BOOL canceledOnTouchOutside;
/**
 * 是否来自桥接APAlertView
 * 如果YES，则回调delegate只回调UIAlertViewDelegate的那些回调方法
 * 避免有些业务混用APAlertView/AUNoticeDialog时两个delegate方法都回调
 */
// @property (nonatomic, assign) BOOL isBridgeFromAP;

- (void)show;
- (void)dismiss;
- (void)dismissWithClickedButtonIndex:(NSInteger)buttonIndex animated:(BOOL)animated;
- (void)enableButton:(BOOL)enable atIndex:(NSInteger)index;
- (void)forceHidden; // 有其他 alertview 要显示到 window 上时调用

- (void)showInView:(UIView *)view;

- (void)showWithCustomView:(UIView *)customView;

//- (UIViewController *) showInController;

+ (void)dismissAll;
+ (BOOL)hasDialogShowing; // 判断当前 app 内各个界面中是否有弹窗展示

- (AUDialogNormalButton *)addCancelButton:(NSString *)buttonTitle actionBlock:(AUDialogActionBlock)actionBlock;
- (AUDialogNormalButton *)addButton:(NSString *)buttonTitle actionBlock:(AUDialogActionBlock)actionBlock;
- (AUDialogNormalButton *)addButton:(NSString *)buttonTitle style:(AUDialogActionStyle) style actionBlock:(AUDialogActionBlock)actionBlock;

//返回按钮View的高度
//调用前先沟通一下，有写死的逻辑
- (CGFloat) buttonViewHeight;

//- (AUDialogActionButton *)addActionButton:(NSString *)aciontTitle actionBlock:(AUDialogActionBlock)actionBlock;
- (void)onButtonClicked:(AUDialogButton *)sender;

- (void)onCanceledTouchOutsideClicked:(id)object __attribute__((objc_requires_super));

- (void)onCloseBtnClickedAction:(AUDialogActionBlock)actionBlock;

+ (BOOL)validString:(NSString *)string;

- (instancetype)initWithCustomView:(UIView *)customView; // 自定义内容区域

- (instancetype)initWithCustomView:(UIView *)customView type:(AUDialogBuilderType)type;

- (NSString *)descriptionWithInfo:(NSString *)info;


- (BOOL) pointInContainView:(CGPoint)point;
/**
 设置自定义视图距离上下左右的边距(AUImageDialog暂不支持)
 
 @param edge 自定义视图边距（如果不需要边距设置NULL，设置调用AUEdgeInsetsMake方法）
 */
- (void)setCustomViewEdge:(AUEdge *)edge;

//设置弹窗内容区域最大高度
- (void)setContentMaxHeight:(CGFloat)maxHeight;

@end

@interface AUDialogBaseView (TA)

-(void) setButtonTextColor:(UIColor *)color forButtonIndex:(NSInteger) index;

@end

#endif//程序自动生成
