#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_BadgeView_AUBadgeView//程序自动生成
//
//  AUBadgeView.h
//  AntUI
//
//  Created by jinzhidong on 2018/3/7.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef enum : NSUInteger {
    AUBadgeViewStyleNone,   //清除红点内容, attributes传nil
    AUBadgeViewStyleRedDot, //红点,无内容, attributes传nil
    
    /*
     红点+内容, attributes:@{kAUBadgeViewAttributeKeyText:@"热门"}
     value.length==0视为异常值直接return,本次调用不做任何操作,保持AUBadgeView原先状态.
     */
    AUBadgeViewStyleText,
    
    /*
     红点+数字, attributes:@{kAUBadgeViewAttributeKeyNumber:@(value)}
     value:1-99显示实际数字;大于99显示（...）;
     0或负数视为异常值,直接return,本次调用不做任何操作,保持AUBadgeView原先状态.
     */
    AUBadgeViewStyleNumber,
    
    /*
     直接设置显示（...）
     */
    AUBadgeViewStyleMore,
    
    /*
     . ==> AUBadgeViewStyleRedDot
     more ==> AUBadgeViewStyleMore
     其他 ==> AUBadgeViewStyleText
     */
    AUBadgeViewStyleAuto
} AUBadgeViewStyle;


//拐角信息
typedef NS_ENUM(NSInteger, AUBadgeViewIndicatorPosition) {
    AUBadgeViewIndicatorPositionNone,
    AUBadgeViewIndicatorPositionLeft,
    AUBadgeViewIndicatorPositionRight,
    AUBadgeViewIndicatorPositionCenter
};

/**
 *
 * 拐角类型
 * value为AUBadgeViewIndicatorPosition的NSNumber
 */
extern NSString *kAUBadgeViewAttributeKeyIndicator;// @"kAUBadgeViewAttributeKeyIndicator"

/**
 * 是否启用屏幕适配
 *@(YES),@(NO)
 */
extern NSString *kAUBadgeViewAttributeScreenScaleEnable;// @"kAUBadgeViewAttributeScreenScaleEnable"

/**
 *气泡文案
 */
extern NSString *kAUBadgeViewAttributeKeyText;// @"kAUBadgeViewAttributeKeyText"

/**
 *
 *数字气泡值
 */
extern NSString *kAUBadgeViewAttributeKeyNumber;// @"kAUBadgeViewAttributeKeyNumber"

/**
 *自定义文本内边距
 */
extern NSString *kAUBadgeViewAttributeKeyCustomInset;// @"kAUBadgeViewAttributeKeyCustomInset"

/**
 *是否需要描边
 * @YES :需要描边
 */
extern NSString *kAUBadgeViewAttributeKeyStrokeEnabled;// @"kAUBadgeViewAttributeKeyStrokeEnabled"

/*
 *文本条件下最多几个汉字，最多设置6个。
*/
extern NSString *kAUBadgeViewAttributeKeyMaxTextLength;

/*
 *是否是老年版本
 */
extern NSString *kAUBadgeViewAttributeKeySeniorsVersion;


/*
 *自定义背景色,Value为UIColor
 */
extern NSString *kAUBadgeViewAttributeBackgroundColor;

/*
 *自定义文字颜色,Value为UIColor
 */
extern NSString *kAUBadgeViewAttributeTextForeColor;

/*
 *自定义红点尺寸,Value为Number
 */
extern NSString *kAUBadgeViewAttributeSizeWidth;




@interface AUBadgeView : UIView<AUScreenScaleSupport>

@property(nonatomic,assign) AUBadgeViewStyle badgeViewStyle;

@property(nonatomic,strong) NSDictionary *attributes;

/**
 根据style绘制红点内容.
 
 @param style AUBadgeViewStyle
 @param attributes 见AUBadgeViewStyle定义
 @return YES:执行了绘制操作(建议重新布局); NO:判断为reuse,不重绘.
 */
- (BOOL)drawBadgeWithStyle:(AUBadgeViewStyle)style
                attributes:(NSDictionary *)attributes;

@end

AUBadgeView *AUBadgeViewRedPointMake(NSDictionary *attributes);

#endif//程序自动生成
