#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_amountInputBox_SimpleAmountInput//程序自动生成
//
//  AUSimpleAmountInputField.h
//  AntUI
//
//  Created by zhaolei on 2017/6/20.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUAmountEditTextFieldNew.h>

@class AUNumKeyboards;
//#########################################################
//文档地址 : https://yuque.antfin-inc.com/antui/auidoc/ios_auamountedittext
//#########################################################


NS_ASSUME_NONNULL_BEGIN

/**
 带"¥"符号和下划线的简版金额输入组件.输入内容字号大小会随内容长度缩放
 */
@interface AUAmountEditTextNew : UIView

/**
 amountTextField.setText时,会进行格式化处理(长度以及非法字符)
 提供delegate.shouldChangeCharactersInRange的代理实现,会对输入内容做长度校验与格式化处理.
 业务方可以自定义delegate.shouldChangeCharactersInRange来覆盖默认实现.
 */
@property (nonatomic,strong) AUAmountEditTextFieldNew *amountTextField;

/// 是否展示顶部单位，默认NO. 每次设置该属性，会重新设置金额输入组件高度，并重新布局
@property (nonatomic,assign) BOOL unitTagVisible;
/// 是否隐藏底部线，默认NO
@property (nonatomic,assign) BOOL bottomLineHidden;


@property (nonatomic,copy) AUNumKeyboards* (^KeyboardSetting)(AUNumKeyboards *);
/**
 开放给AUAmountLabelText,用于inputText长度变化时调整字号使用.
 业务方不要使用.
 
 @param textLength inputText长度
 @return UIFont
 */
+ (UIFont *)resetFontSize:(NSUInteger) textLength;


/**
 *  返回首字符的位置，如果数字增多导致被挤压出去，是不会更新的。
 *  @return CGPoint, x是首字符的centerX，y是分割线的top
 */
- (CGPoint) firstCharactorPosition;

@end

NS_ASSUME_NONNULL_END

#endif//程序自动生成
