//
//  DTService.h
//  MobileCore
//
//  Created by WenBi on 13-4-3.
//  Copyright (c) 2013年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AntNetworkAdapterMacro.h"

#if USE_MPASS_SDK
/**
 * \code DTService 代表一个服务。
 */
@protocol DTService <NSObject>

@required

/**
 * 启动一个服务。框架在完成初始化操作后，会调用该方法。
 *
 * 如果一个服务要启动一个应用，必须在该法被调用之后，才能启动其它的应用。
 */
- (void)start;

@optional
/**
 *  服务已经完成创建。
 */
- (void)didCreate;

/**
 *  服务即将释放。
 *  服务开始做销毁准备：(包括但不限于)
 *   1.停止Timer
 *   2.Suspend当前运行的线程
 *   3.释放高内存占用对象
 *   4.反注册各类通知和回调
 *   5.etc..
 *
 *  注意事项：
 *     1.请勿做耗时操作
 */
- (void)willDestroy;

/**
 *  服务是否可以销毁，默认YES
 *
 *  param = {
 *     NSString *type = @"DTRegionChange"
 *     NSString *productId = @"IPHONE_1ND"
 *     NSString *curRegion = @"CN"
 *     NSString *desRegion = @"MO"
 *  }
 * 
 *  注意事项：
 *     1.请勿做耗时操作
 *     2.可能会被多次调用
 */
- (BOOL)serviceShouldTerminate:(NSDictionary*)param;


/**
 *  需要保活的服务在地区切换后再次初始化的回调，只对不销毁的服务生效
 *  即 -serviceShouldTerminate 返回false
 *  param = {
 *     NSString *productId = @"IPHONE_1ND"
 *     NSString *curRegion = @"MO"
 *     NSString *preRegion = @"CN"
 *  }
 */
- (void)handleRegionChange:(NSDictionary*)param;

@end

#endif
