//
//  DTNetworkAdapterUtils.h
//  NetworkCtlService
//
//  Created by cuinacai on 2021/6/4.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>



@interface DTNetworkAdapterUtils : NSObject
/**
 *  @return 是否mpaas输出场景。
 */
+ (BOOL)ismPaaSEnvironment;
/**
 *  @return 是否输出场景。
 */
+ (BOOL)isOutputEnvironment;

/**
 *  注意：作为客户端标识，不区分平台和版本。如,"ALIPAY_WALLET","ALIPAY_WALLET_MO"
 *
 *  @return 返回当前客户端的ID。
 */
+ (NSString *)productName;

/**
 *  获取当前Product Id。内部会处理性能和缓存问题，业务方请直接使用接口，不要自行缓存，避免切换地区场景中，productId更新时获取不同步的问题
 *
 *  @return 返回当前Product Id。如,"IPHONE_1ND","IPHONE_1ND_DEV","ALIPAY_MO_IOS_RC"
 */
+ (NSString *)productId;

/**
 *  获取当前Product Id。
 *
 *  @return 返回当前Product Id。如"IPHONE_1ND_RC"，"ALIPAY_MO_IOS_RC"
 */
+ (NSString *)originalProductId;

/**
 *  获取设置无线保镖接口的authCode值
 *
 *  根据 < enableMPaaSAuthCode > 的返回值，若为NO，此方法返回nil；若为 YES，此方法返回 @"1000"；
 *  钱包中默认为nil，mPaaS 用户根据需要重写 < enableMPaaSAuthCode > 方法
 *
 *  @return 默认返回 nil
 */
+ (NSString *)openSecurityAuthCode;

//是否越狱
+(BOOL)isJailbroken;

/**
 App当前处于后台
 注意：！！如果main之前获取，认为是前台
 @return YES 后台 ; NO前台或回前台过程中
 */
+ (BOOL)isBackground;

// 当前正处于 BackgroundFetch 后台唤起
// 此值仅在主线程修改
// 首次Background Fetch时不为YES。第二次及后续的Background Fetch为YES。
// 回到前台时(willEnterForeground)会改为NO。
// 此值需要在对应的MpaasAdapter中维护（APMobileframework没有维护此值）
+ (BOOL)underBackgroundFetch;

+(NSString*)UTDID;

//不可用埋点
+(void)MTBIZ_Report:(NSString*)bizName subName:(NSString*)subName failCode:(NSInteger)failCode params:(NSDictionary*)params;

//======================登录相关======================
/**
 *  获取用户id
 *
 *  @return 当前登录的userId
 */
+ (NSString*)userId;
/**
 *  判断是否已经登录YES表示已经登录，NO表示没有登录
 *
 *  @return
 */
+ (BOOL)isUserLogin;
/**
 *  返回当前登录的sessionId
 *
 *  @return
 */
+ (NSString*)sessionId;

/**
 *  返回AMDC线上host
 *
 *  @return
 */
+ (NSString*)amdcOnlineHost;
+ (NSString*)amdcBackupIp;
+ (NSString*)amdcDg;
+ (NSString*)amdcDomainList;
+ (BOOL)amdcSwitch;
//SYNC老库长链接相关host
+ (NSString *)longConnectionURL;
//SYNC老库长链接相关online
+ (BOOL)isPMGWOnline;
//SYNC老库长链接相关port
+ (NSInteger)longConnectionPort;
//检测当期代理是否为VPN
+(BOOL)isVPNConnected;
+ (NSString *)appId;
+ (NSString *)workspaceId;
+ (NSString *)appKey;
+ (NSString *)platform;
+ (NSString*)h2networkHost;
+ (NSString*)h2networkPort;
+ (NSString*)h2networkCertificateName;
+ (BOOL)networkInited;
+(void)refreshVPN;
@end


