//
//  DTNetworkAdapterInterface.h
//  AntNetworkAdapter
//
//  Created by JiaJun on 2022/12/31.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface DTNetworkAdapterInterface : NSObject

/**
 *  获取单例
 */
+ (instancetype)sharedInstance;

/**
 * 是否使用网络库
 */
- (BOOL)useNetwork;

/**
 * RPC是否使用网络库
 */
- (BOOL)useNetworkForRpc:(NSString *)url;

/**
 * Push是否使用网络库
 */
- (BOOL)useNetworkForPush;

/**
 * Sync是否使用网络库
 */
- (BOOL)useNetworkForSync;

/**
 * MDC是否使用网络库
 */
- (BOOL)useNetworkForMdc;

/**
 * 是否忽略证书校验
 */
- (BOOL)ignoreCertificateVerification;

@end

NS_ASSUME_NONNULL_END
