//
//  ASUpdateAlertManager.h
//  AccountSecurity
//
//  Created by ouxi on 16/3/14.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ASAlertView.h"

typedef void(^ASAlertViewClickBlock)(int btnIndex, ASAlertView *alertView);

@interface ASUpdateAlertManager : NSObject

@property(nonatomic, strong, readonly)ASAlertView *currentAlert;

/**
 实例化

 @return 单例对象
 */
+ (instancetype)sharedInstance;

/**
 判断弹框是否有效

 @return YES、NO
 */
- (BOOL)alertVisible;

/**
 隐藏弹框
 */
- (void)hiddenAlert;

/**
 显示弹框

 @param targetVersion     标题
 @param headerImage       图片
 @param updateMessage     消息
 @param cancelButtonTitle 取消按钮
 @param sureButtonTitle   确定按钮
 @param btnIndex          点击的按钮
 */
- (void)showUpgradeAlertWithTitle:(NSString *)targetVersion
                           header:(UIImage *)headerImage
                          message:(NSString *)updateMessage
                cancelButtonTitle:(NSString *)cancelButtonTitle
                  sureButtonTitle:(NSString *)sureButtonTitle
                       onClickBtn:(ASAlertViewClickBlock)btnIndex;

@end
