//
//  AUNumKeyboards.h
//  AntUI
//
//  Created by QiXin on 2016/9/26.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AUKeyboard/AUNumKeyboardsDefs.h>

//#########################################################
//文档地址 : https://yuque.antfin-inc.com/antui/auidoc/ios_aunumkeyboards
//#########################################################





/**
 支付宝自定义数字键盘
 文档:http://idoc.alipay.net/article/57fb366e22ec746a420304dd
 */
@interface AUNumKeyboards : UIView

/**
 *  创建键盘组件，默认为通用键盘
 *
 *  @return 初始化的键盘组件
 */
+ (AUNumKeyboards *)sharedKeyboard;

/**
 *  创建键盘组件
 *
 *  @param mode 键盘模式
 *
 *  @return 初始化的键盘组件
 */
+ (AUNumKeyboards *)sharedKeyboardWithMode:(AUNumKeyboardMode)mode;


/**
 *  手动设置textinput，外部需要设置keyboard的y轴
 */
@property (nonatomic, weak) id<UITextInput> textInput;

/**
 *  身份证x
 */
@property (nonatomic, assign) BOOL idNumber;

/**
 *  设置键盘模式
 */
@property (nonatomic, assign) AUNumKeyboardMode mode;

/**
 *  小数点，是否隐藏
 */
@property (nonatomic, assign) BOOL dotHidden;

/**
 *  是否隐藏收起键盘
 */
@property (nonatomic, assign) BOOL dismissHidden;

/**
 *  提交按钮是否可点
 */
@property (nonatomic, assign) BOOL submitEnable;

/**
 *  提交按钮文案
 *  注意：根据视觉要求，此文案最多显示三个汉字，国际化时请注意英文文案长度
 */
@property (nonatomic, strong) NSString *submitText;


/**
 * 是否禁用提交按钮自动disable/enable
 * 目前逻辑是根据绑定的input.text.length > 0来判断
 * 如果设置为YES，那么逻辑纯靠业务自己设置submitEnable。
 *
 */
@property (nonatomic, assign) BOOL disableAutoSubmitEnable;


/**
 *  设置回退按钮
 *  @param  button，回退按钮
 *  @param isSmallMode, 是否是小屏幕模式，YES表示高度小于1136px的机器

 *  注意：国际化时请注意英文文案长度
 */
@property (nonatomic, copy) void (^backspaceButtonSetting)(UIButton *button,BOOL isSmallMode);

@property (nonatomic, assign) BOOL displaySafeText;

@property (nonatomic, assign) BOOL topSepLineHidden;

/**
 键盘乱序
 注意：每调用一次，都会乱序重排一次

 @param random YES，乱序一次；NO，不乱序
 */
- (void)setNumKeyRandom:(BOOL)random;

//提交按钮是否可点
@property (nonatomic, copy) BOOL (^submitEnableBlock)(BOOL isEnable);

@end
/**
 *@param mode,键盘类型，新版本都是AUV2 键盘，其中以Pad结尾的键盘是没有“确定”按钮的，三列排布；不以Pad结尾的是带“确定”按钮的四列文案
 *@param displayAlipaySafetyText, 是否要显示顶端“支付宝安全保护中“文案
 *@param confirmButtonText, 自定义“确认”按钮文案（如果有），长度==0使用默认的“确定”文案
 */
AUNumKeyboards * AUV2NumKeyboardsMake(AUNumKeyboardMode mode,BOOL displayAlipaySafetyText,NSString *confirmButtonText);

UIButton *AUV2NumKeyBoardDefaultMake(BOOL displaySafeText);


extern BOOL AUV2NumbericKeyBoardForceSmallVersion;


extern NSString *AUNumKeyboardsDidDismissNotification;

