//
//  UIView+Helper.h
//  MobileFoundation
//
//  Created by shenmo on 11/13/14.
//  Copyright (c) 2014 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface UIView (Miscellaneous)

/**
 * Finds the first descendant view (including this view) that is a member of a particular class.
 */
- (UIView*)descendantOrSelfWithClass:(Class)cls;

/**
 * Finds the first ancestor view (including this view) that is a member of a particular class.
 */
- (UIView*)ancestorOrSelfWithClass:(Class)cls;

/**
 * Removes all subviews.
 */
- (void)removeAllSubviews;

/**
 * The view controller whose view contains this view.
 */
- (UIViewController*)viewController;




@end

@interface UIView (Dimension)

/**
 * Shortcut for frame.origin.x.
 *
 * Sets frame.origin.x = left
 */
@property (nonatomic) CGFloat left;
@property (nonatomic) CGFloat x;

/**
 * Shortcut for frame.origin.y
 *
 * Sets frame.origin.y = top
 */
@property (nonatomic) CGFloat top;
@property (nonatomic) CGFloat y;

/**
 * Shortcut for frame.origin.x + frame.size.width
 *
 * Sets frame.origin.x = right - frame.size.width
 */
@property (nonatomic) CGFloat right;

/**
 * Shortcut for frame.origin.y + frame.size.height
 *
 * Sets frame.origin.y = bottom - frame.size.height
 */
@property (nonatomic) CGFloat bottom;

/**
 * Shortcut for frame.size.width
 *
 * Sets frame.size.width = width
 */
@property (nonatomic) CGFloat width;
@property (nonatomic) CGFloat w;

/**
 * Shortcut for frame.size.height
 *
 * Sets frame.size.height = height
 */
@property (nonatomic) CGFloat height;
@property (nonatomic) CGFloat h;

/**
 * Shortcut for center.x
 *
 * Sets center.x = centerX
 */
@property (nonatomic) CGFloat centerX;

/**
 * Shortcut for center.y
 *
 * Sets center.y = centerY
 */
@property (nonatomic) CGFloat centerY;

/**
 * Return the x coordinate on the screen, taking into account scroll views.
 */
@property (nonatomic, readonly) CGFloat screenViewX;

/**
 * Return the y coordinate on the screen, taking into account scroll views.
 */
@property (nonatomic, readonly) CGFloat screenViewY;

/**
 * Shortcut for frame.origin
 */
@property (nonatomic) __attribute__((unavailable("iOS 13私有属性，请切换至origin_au"))) CGPoint origin;

/**
 * Shortcut for frame.size
 */
@property (nonatomic) __attribute__((unavailable("iOS 13私有属性，请切换至size_au"))) CGSize size;


/**
 * Shortcut for frame.origin
 */
@property (nonatomic)  CGPoint origin_au;

/**
 * Shortcut for frame.size
 */
@property (nonatomic)  CGSize size_au;

/**
 * Shortcut for frame.origin
 */
@property (nonatomic) CGPoint origin_mp;

/**
 * Shortcut for frame.size
 */
@property (nonatomic) CGSize size_mp;





@end
