//
//  AUFontShell.h
//  AUBase
//
//  Created by Wang on 2021/5/26.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface AUFontShell : NSObject

/**
 使用字体data注册字体
 
 @param data 字体data
 @param error 注册失败的错误
 @return 字体名称
 */
+ (NSString *)registerFontWithData:(NSData *)data error:(NSError **)error;

+ (BOOL) unregisterFontWithName:(NSString *)fontName error:(NSError **)error;

+ (BOOL) fontExist:(NSString *)fontName fontFamily:(NSString *_Nullable)fontFamily;

@end

@interface AUAPFontShell : NSObject

+(UIFont *) APNumberFont:(CGFloat) size;

@end

//返回支付宝数字字体
//如果没有，则返回一个系统的等宽数字字体。
UIFont *AUFAPNumberFont(CGFloat size);

NS_ASSUME_NONNULL_END
