//
//  APImageManager.h
//  BeeLottiePlayer
//
//  Created by Wang on 2020/11/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <AUBase/AUBMediaBase.h>


NS_ASSUME_NONNULL_BEGIN

@protocol AUBImageDownloadResponse;

/**
   图片请求的类型，包括等比图 大图 原图和裁切图四种 具体见：https://lark.alipay.com/amm/apis/about-crop
 */
//typedef enum : NSUInteger {
//    APImageRequestTypeScale = 0, //等比缩放
//    APImageRequestTypeBig = 1, //大图
//    APImageRequestTypeOriginal = 2,      //原图
//    APImageRequestTypeCut = 4          //非等比裁剪文件
//} APImageRequestTypeEnum;







typedef void (^AUBImageDownloadRequestComplete)(id<AUBImageDownloadResponse> response) ;
typedef void (^AUBImageDownloadPJPEGBlock)(NSString *identifier,UIImage *pImage);



@protocol AUBImageRequest <AUBBaseDownloadRequest>

/**
 *  当设置imageRequestType这个值的时候， 以imageRequestType的设置值为准。https://lark.alipay.com/amm/apis/about-crop 当imageRequestType未设置，则走以前的老逻辑根据originalSize和zoom的值来决定imageRequestType； 强烈建议设置此值来决定。智能裁切的默认类型为APImageRequestTypeCut
 *  根据size和originalSize来计算图片的类型（原图，大图，等比缩略图，裁切缩略图），计算规则如下
    1、originalSize为CGSizeZero，表示原图
    2、size为CGSizeZero，表示大图（此时originalSize不能为CGSizeZero）
    3、如果size和originalSize的宽高比是一样的（两者的差的绝对值小于0.001），则图片类型为等比缩略图，否则是裁切缩略图
 */
@property (nonatomic, assign) NSUInteger imageRequestType;

/**
 *   当为等比图或者裁切图时候，决定返回图片的大小。
 ＊  当是等比图的时候，返回图片的一条边的尺寸和zoom相等，另外一条边小于或者等于zoom的另外一条边，当为裁切图的时候。返回尺寸和zoom相同
 */
@property (nonatomic, assign) CGSize zoom;


/**
 下载完成回调
 */
@property (nonatomic, copy) AUBImageDownloadRequestComplete downLoadCompletion;

/**
 *  0为默认值回调返回是UIImage，为1时返回是NSData;
 */
@property (nonatomic, assign) NSUInteger respType;





@end

@protocol AUBImageDownloadResponse <NSObject>

/**
 *  cloud Id 或者是外部URL
 */
@property (nonatomic, strong) NSString* identifier;

/**
 *  下载返回的图片对象
 */
@property (nonatomic, strong) UIImage* image;

/**
 *  如果请求失败，error中包含失败信息
 */
@property (nonatomic, strong) NSError* error;

/**
 *  当请求二进制数据的数据的时候 imageData是图片的二进制表示
 */
@property (nonatomic, strong) NSData* imageData;


@end





@protocol AUBImageManager <NSObject>

@required

- (BOOL)isImageCacheExsitFor:(NSString*)identifier request:(id<AUBImageRequest>)request;

- (id<AUBImageDownloadResponse>)syncGetImageCacheForIdentifier:(NSString*)identifier request:(id<AUBImageRequest>)request;

- (BOOL)storeImageIntoCache:(UIImage *)image withIdentifier:(NSString *)identifier imageRequest:(id<AUBImageRequest>)request;

- (void)clearCacheForIdentifier:(NSString *)identifier;

/**
 *  支持DJANGO图片下载，以及外部url图片下载 (仅DJango图片支持不同Q值下载)
 *
 *  @param param    APImageRequestParam
 *  @param progress
 *  @param complete 下载完成回调，主线程返回
 *
 *  @return
 */
- (NSString *)getImage:(NSString*)identifier
               request:(id<AUBImageRequest>)request;

@end


id<AUBImageManager> AUBImageManagerGet();

id<AUBImageRequest> AUBImageRequest();



NS_ASSUME_NONNULL_END
