
//
//  APFileManager.h
//  APMultimedia
//
//  Created by Monster on 15/4/11.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <AUBase/AUBMediaBase.h>

@protocol AUBFileDownloadResponse;


typedef void (^AUBFileDownloadRequestComplete)(id<AUBFileDownloadResponse> response);


@protocol AUBFileDownloadRequest <AUBBaseDownloadRequest>

/**
 *  下载文件的md5值， 如果不为空，则会进行校验。校验失败，error返回错误信息。
 */
@property (nonatomic, copy) NSString *md5;

/**
 * 文件下载到指定的路径，指定storePath后，下载后数据不存缓存，下载后的文件业务方自己管理。如果不指定storePath，则认为是按照二进制流下载。会直接影响到下载完成回调中返回值
 */
@property (nonatomic, copy) NSString *storePath;

/**
 *  下载的是否是zip压缩文件，如果是zip文件，将会解压缩， 只有指定了storePath这个参数才有效。
 */
@property (nonatomic, assign,getter = isZip) BOOL Zip;

/**
 *  文件下载结束的回调
 */
@property (nonatomic, copy) AUBFileDownloadRequestComplete downloadReuestCompletion;





@end


/**
 * 下载指定存储路径storePath有值，否则data将返回值
 */
@protocol AUBFileDownloadResponse

@property (nonatomic, copy) NSString *cloudId;


@property (nonatomic, strong) NSData *data;
/**
 文件下载后的存储目录，storepath对于对于zip文件，filePath为文件的为解压后的文件目录；对于非zip文件，对于cloudid或者url，为业务方传入的storePath，需要自己拼凑最终的路径，建议使用filePath，filePath指向最终文件路径
 */
@property (nonatomic, copy) NSString *storePath;
@property (nonatomic, strong) NSError *error;

/**
 对于非zip文件，filePath为文件下载后的文件路径；对于zip文件，filePath为文件的为解压后的文件目录
 */
@property (nonatomic, copy) NSString *filePath;

/**
 获取数据的来源，只有当有数据返回的时候，才有意义，当response中有error的时候，sourceType不确定
 */
@property (nonatomic, assign) NSInteger sourceType;


@end


@protocol AUBFileManager <NSObject>


@required
/**
 *  下载文件，对于非zip文件， 如果指定storepath目录，已经存在同名的文件 则直接返回，不会触发网络请求。
 *
 *  @param cloudId         cloudId
 *  @param downloadRequest 下载请求的相关配置
 *
 *  @return cloudId
 */
- (NSString *)downloadFileWithCloudId:(NSString *)cloudId downloadRequest:(id<AUBFileDownloadRequest>)downloadRequest;


/**
 根据cloud id/local id或者url拿到文件的缓存地址，支持文件和视频id

 @param identifier cloud id/local id或者url
 @return 如果本地缓存存在则返回l存储路径，否则则返回nil;
 */
- (NSString *)cachePathWithIdentifier:(NSString*)identifier;



@end


id<AUBFileManager> AUBFileManagerGet();

id<AUBFileDownloadRequest> AUBFileDownloadRequest();
