//
//  AUAntMationShell.h
//  AntUI
//
//  Created by niki on 2020/7/30.
//  Copyright © 2020 Alipay. All rights reserved.
//

#ifndef AUAntMationShell_h
#define AUAntMationShell_h

#import <AUBase/AULottieShell.h>

@class AntMationModel;
@class AntMationView;

NS_ASSUME_NONNULL_BEGIN

NSInteger AUAntMationRenderTypeSkottie() __attribute__((weak));
NSInteger AUAntMationRenderTypeAnt2D() __attribute__((weak));
NSInteger AUAntMationRenderTypeMars() __attribute__((weak));


@protocol AntMationModelProtocol <NSObject>

@property (nonatomic, copy) NSString * _Nullable rootPath;
@property (nonatomic, copy) NSString * _Nullable runtimePath;
@property (nonatomic, strong) NSDictionary * _Nullable runtimeDigests;
@property (nonatomic, strong) NSDictionary * _Nullable params; // 参数化数据集，主要包括图片、颜色、文案、字体等
@property (nonatomic, copy) NSString * _Nonnull bizType;
@property (nonatomic, strong) NSDictionary * _Nullable preload; // runtime时需要去加载的文件路径集合，主要包括字体路径等。
@property (nonatomic, assign) NSInteger renderType; // 默认是 Ant2D
@property (nonatomic, strong) NSDictionary * _Nullable lottieContentDic; // 动画内容即Lottie.json读取出来的数据集合
@property (nonatomic, assign) BOOL dynamicLayerEnable; // 默认NO，只有开启才会响应点击


@end



@interface AUAntMationShell : NSObject

// lottie视图异步加载
+ (id)animationiewWithFilePath:(NSString *)filePath
                         bizType:(NSString *)bizType
                          params:(NSDictionary<NSString *,NSString*> *)params
                      completion:(LottieSetupBlock)completion;



+ (id)animationWithModel:(void(^_Nullable)(id<AntMationModelProtocol> _Nullable model))model
                completion:(void(^_Nullable)(BOOL success,
                                                NSString * _Nullable err,
                                        id animationView))completion;


+ (BOOL)isSupportWithType:(NSInteger)type;
//
+ (BOOL)isSupport;

@end


BOOL AUBIsKindOfAntmation(NSObject *o) __attribute__((weak));


NS_ASSUME_NONNULL_END


#endif /* AUAntMationShell_h */
