//
//  APStorageCleanContext.h
//  APStorageCenter
//
//  Created by kongzhaoyang on 2021/8/23.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, APStorageCleanWarningType) {
    APStorageCleanWarningTypeNone = 0,                    // 不执行任何操作
    APStorageCleanWarningTypeSupersize,                   // 目录超大异常，默认值1G
    APStorageCleanWarningTypeRateLow,                     // 目录存储使用率低，默认值14天50%
    APStorageCleanWarningTypeOversize,                    // 业务超过配额，改业务下所有目录之和超过配额大小
};

@class APStorageCleanFileInfo;
@class APStorageMonitorBizInfo;

@interface APStorageCleanContext : NSObject

/**
 * 存储巡检警告，建议执行自动清理，提供参考信息
 * APStorageCleanWarningTypeSupersize目录超大异常，可用信息directoryPath，directorySize
 * APStorageCleanWarningTypeRateLow目录存储使用率低，可用信息directoryPath，directorySize，accessRate，cleanFiles
 * APStorageCleanWarningTypeOversize业务超过配额，可用信息businessName，businessSize
 */
@property (nonatomic, assign) APStorageCleanWarningType cleanWarningType;

/**
 * 超配额的业务名称，APStorageCleanWarningTypeOversize独有
 */
@property (nonatomic, copy) NSString *businessName;

/**
 * 业务当前大小，APStorageCleanWarningTypeOversize独有
 */
@property (nonatomic, assign) unsigned long long businessSize;

/**
 * 目录绝对路径
 */
@property (nonatomic, copy) NSString *directoryPath;
/**
 * 目录大小
 */
@property (nonatomic, assign) unsigned long long directorySize;

/**
 * 存储使用率，范围0~1，APStorageCleanWarningTypeRateLow独有
 */
@property (nonatomic, assign) float accessRate;

/**
 * N天未访问，建议清理的文件，APStorageCleanWarningTypeRateLow独有
 */
@property (nonatomic, copy) NSArray <APStorageCleanFileInfo *>* cleanFiles;

/**
 * ID排序，最应该删除的在最后面
 */
@property (nonatomic, copy) NSArray <APStorageMonitorBizInfo *>*sortedIdentifiers;

@end

NS_ASSUME_NONNULL_END
