//
//  APSharedPreferences+APStorageCenter.h
//  APStorageCenter
//
//  Created by SUOMAN on 2021/8/25.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <MPDataCenter/MPDataCenter.h>

NS_ASSUME_NONNULL_BEGIN

/// APSharedPreferences 接口包装
/// 获取指定 bundle 下的 APSharedPreferences KV，不传入 bundle 代表当前调用方
/// 返回 nil 代表无权限

@interface APSharedPreferences (APStorageCenter)

- (NSInteger)integerForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (NSInteger)integerForKey:(NSString*)key bundle:(nullable NSString *)bundle defaultValue:(NSInteger)defaultValue;

- (BOOL)setInteger:(NSInteger)value forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (long long)longLongForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (long long)longLongForKey:(NSString*)key bundle:(nullable NSString *)bundle defaultValue:(long long)defaultValue;

- (BOOL)setLongLong:(long long)value forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)boolForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)boolForKey:(NSString*)key bundle:(nullable NSString *)bundle defaultValue:(BOOL)defaultValue;

- (BOOL)setBool:(BOOL)value forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (double)doubleForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (double)doubleForKey:(NSString*)key bundle:(nullable NSString *)bundle defaultValue:(double)defaultValue;

- (BOOL)setDouble:(double)value forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (NSString*)stringForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (NSString*)stringForKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (BOOL)setString:(NSString*)string forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)setString:(NSString*)string forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (id)objectForKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (id)objectForKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (id)objectForKey:(NSString*)key bundle:(nullable NSString *)bundle expectedClass:(Class)expectedClass error:(NSError**)error;

- (BOOL)setObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)setObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (BOOL)setObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension options:(APDataOptions)options;

- (BOOL)archiveObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)archiveObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (BOOL)archiveObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension options:(APDataOptions)options;

- (BOOL)saveJsonObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle;

- (BOOL)saveJsonObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension;

- (BOOL)saveJsonObject:(id)object forKey:(NSString*)key bundle:(nullable NSString *)bundle extension:(APDataCrypt*)extension options:(APDataOptions)options;

@end

NS_ASSUME_NONNULL_END
