//
//  ATLogAppendDispatcher.h
//  APRemoteLogging
//
//  Created by feisong on 7/12/19.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APRemoteLogging/ATEvent.h>

@class ATLogMessage;

NS_ASSUME_NONNULL_BEGIN



//文本字符串数据回流
@protocol LogAppendDispatcher <NSObject>

@optional

/**
 回调接口

 @param message 回调内容
 */
-(void)onLogAppend:(ATLogMessage*)message;

@end



@interface ATLogAppendDispatcher : NSObject

@property(nonatomic,strong) NSOperationQueue *dispatchQueue;
/**
 获取实例

 @return 实例
 */
+(instancetype)sharedInstance;


/**
 获取字符串的分流器

 @return 实例
 */
-(NSArray*)getAppendDispatcherList;

/**
 获取结构化数据的分流器

 @return 实例
 */
-(NSArray*)getSchemaAppendDispatcherList;
/**
 注册分发器

 @param dispatcher 分发器
 */
-(void)registerAppendDispatcher:(id<LogAppendDispatcher>)appendDispatcher;


/**
 注册字符串数据分发器

 @param dispatcher 分发器
 @param 需要分流的数据类型  包含  具体的bizType 或者 数据模型名 [事件化埋点：AntEvent]  [手动行为埋点：AntBehavior]  [Schema埋点：AntSchema]   [性能埋点：AntPerformance]
 */
-(void)registerAppendDispatcher:(id<LogAppendDispatcher>)appendDispatcher withBizList:(NSArray*)bizList;



@end

@interface ATLogAppendDispatcherData : NSObject

@property(nonatomic,strong) id<LogAppendDispatcher> dispatcher;
@property(nonatomic,strong) NSArray* bizList;

@end

NS_ASSUME_NONNULL_END
