//
//  IStaticCryptoModule.h
//  APSecSecuritySDK
//
//  Created by hongren on 2022/4/25.
//  Copyright © 2022 Alipay. All rights reserved.
//

#ifndef IStaticCryptoModule_h
#define IStaticCryptoModule_h

#import "ITrustedModule.h"

extern const NSInteger TRUSTED_CRYPTO_MODE_DJY_FEATURE;
extern const NSInteger TRUSTED_CRYPTO_MODE_SG_AES_128;
extern const NSInteger TRUSTED_CRYPTO_MODE_BS_SM4_GCM;
extern const NSInteger TRUSTED_CRYPTO_MODE_BS_AES_128;

@protocol IStaticCryptoModule <ITrustedModule>

@required
//- (NSData*) staticBinarySafeEncryptNoB64: (NSInteger) mode
//                                  forKey: (NSString*) key
//                     forNeedProcessValue: (NSData*) needProcessValue
//                                authCode: (NSString*) authCode;
- (NSData *) encrypt: (NSInteger) mode
                 key: (NSString*) key
                data: (NSData*) plainData
                auth: (NSString*) authCode;

@required
//- (NSData*) staticBinarySafeDecryptNoB64: (NSInteger) mode
//                                  forKey: (NSString*)key
//                     forNeedProcessValue: (NSData*) needProcessValue
//                                authCode: (NSString*) authCode;
- (NSData *) decrypt: (NSInteger) mode
                 key: (NSString*) key
                data: (NSData*) cipherData
                auth: (NSString*) authCode;

@required
//- (NSData*) staticBinarySafeEncrypt: (NSInteger) mode
//                             forKey: (NSString*) key
//                forNeedProcessValue: (NSData*) needProcessValue
//                           authCode: (NSString*) authCode;
- (NSData *) encryptBase64: (NSInteger) mode
                       key: (NSString*) key
                      data: (NSData*) plainData
                      auth: (NSString*) authCode;

@required
//- (NSData*) staticBinarySafeDecrypt: (NSInteger) mode
//                             forKey: (NSString*)key
//                forNeedProcessValue: (NSData*) needProcessValue
//                           authCode: (NSString*) authCode;
- (NSData *) decryptBase64: (NSInteger) mode
                       key: (NSString*) key
                      data: (NSData*) cipherData
                      auth: (NSString*) authCode;

@required
//- (NSString*) staticSafeEncrypt: (NSInteger) mode
//                         forKey: (NSString*) key
//            forNeedProcessValue: (NSString*) needProcessValue
//                       authCode: (NSString*) authCode;
- (NSString *) encryptStringBase64: (NSInteger) mode
                               key: (NSString*) key
                              data: (NSString*) plainData
                              auth: (NSString*) authCode;

@required
//- (NSString*) staticSafeDecrypt: (NSInteger) mode
//                         forKey: (NSString*) key
//            forNeedProcessValue: (NSString*) needProcessValue
//                       authCode: (NSString*) authCode;
- (NSString *) decryptStringBase64: (NSInteger) mode
                               key: (NSString*) key
                              data: (NSString*) cipherData
                              auth: (NSString*) authCode;

@end

#endif /* IStaticCryptoModule_h */
