//
//  ISafeSignatureModule.h
//  APSecSecuritySDK
//
//  Created by hongren on 2022/5/18.
//  Copyright © 2022 Alipay. All rights reserved.
//

#ifndef ISafeSignatureModule_h
#define ISafeSignatureModule_h

#import "ITrustedModule.h"

@protocol ISafeSignatureModule <ITrustedModule>

extern const  NSInteger  SAFE_SIGNATURE_ALGO_SM3_WITH_SM2;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_HMAC_SM3;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_HMAC_MD5;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_HMAC_SHA1;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_HMAC_SHA256;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SM3_ONLY;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_MD5_ONLY;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SHA1_ONLY;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SHA256_ONLY;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SG_SM3;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SG_MD5;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SG_SHA1;
extern const  NSInteger  SAFE_SIGNATURE_ALGO_SG_SHA256;

@required
- (BOOL) verify: (NSInteger) algo
         appkey: (NSString*) appkey
        message: (NSData*) data
           sign: (NSData*)sig;

@required
- (BOOL) verify: (NSInteger) algo
            key: (NSData*) key
        message: (NSData*) data
           sign: (NSData*)sig;

@required
- (NSData*) sign: (NSInteger) algo
          appkey: (NSString*) appkey
         message: (NSData*) data;

@required
- (NSData*) sign: (NSInteger) algo
             key: (NSData*) key
         message: (NSData*) data;

@required
- (NSString*) signString: (NSInteger) algo
                  appkey: (NSString*) appkey
                 message: (NSString*) data;

@required
- (NSString*) signString: (NSInteger) algo
                     key: (NSData*) key
                 message: (NSString*) data;
@end


#endif /* ISafeSignatureModule_h */
