//
//  ISafeOtpModule.h
//  APSecSecuritySDK
//
//  Created by hongren on 2022/3/19.
//  Copyright © 2022 Alipay. All rights reserved.
//

#ifndef ISafeOtpModule_h
#define ISafeOtpModule_h

#import "ITrustedModule.h"

@protocol ISafeOtpModule <ITrustedModule>

extern const  NSInteger  SAFE_OTP_ALGO_HMAC_SM3;
extern const  NSInteger  SAFE_OTP_ALGO_HMAC_SHA256;

/// OTP算法的封装
/// @param algo  算法类型，支持HMAC_SHA256和HMAC_SM3算法
/// @param seed  服务端下发种子，长度大于128bytes，必须是Hex格式
/// @param challenge  待校验的信息（与服务端共享），可以是用户相关或者设备相关（用于增强安全性）
/// @param timestamp 秒级时间戳，必须与服务端进行过时间同步（1970-1-1秒数）
/// @param interval 时间窗口，比如30s
/// @param digits 码位数，比如OTP动态码为６个数字（大于等于1小于10）
/// @return 按指定位数返回OTP码
@required
- (NSString *) getOtpComon: (NSInteger) algo
                      seed: (NSString*) seed
                 challenge: (NSString*) challenge
                 timestamp: (long) timestamp
                  interval: (int) interval
                    digits: (int) digits;

/// OTP算法的封装
/// @param algo  算法类型，支持HMAC_SHA256和HMAC_SM3算法
/// @param secret  一机一密加密后的OTP种子，可以是单独调用一机一密的结果，也可以是信封解密的结果
/// @param challenge  待校验的信息（与服务端共享），可以是用户相关或者设备相关（用于增强安全性）
/// @param timestamp 秒级时间戳，必须与服务端进行过时间同步（1970-1-1秒数）
/// @param interval 时间窗口，比如30s
/// @param digits 码位数，比如OTP动态码为６个数字（大于等于1小于10）
/// @return 按指定位数返回OTP码
@required
- (NSString *) getOtpComonWithSecret: (NSInteger) algo
                              secret: (NSData*) secret
                           challenge: (NSString*) challenge
                           timestamp: (long) timestamp
                            interval: (int) interval
                              digits: (int) digits;
@end


#endif /* ISafeOtpModule_h */
