//
//  EvelopeCryptoDefines.h
//  APSecSecuritySDK
//
//  Created by hongren on 2022/3/17.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

extern const NSInteger MASTER_ALGORITHM_SM2_PUBLIC_KEY;
extern const NSInteger MASTER_ALGORITHM_SM4_ECB_NONE_PADDING;
extern const NSInteger SESSION_ALGORITHM_SM4_GCM_NONE_PADDING;

@interface EvelopeCryptoParams : NSObject

@property (nonatomic, assign) NSInteger masterAlgo;
@property (nonatomic, assign) NSInteger sessionAlgo;
@property (nonatomic, strong) NSData* masterKey;
@property (nonatomic, strong) NSData* sessionKey;
@property (nonatomic, strong) NSData* sessionIV;
@property (nonatomic, strong) NSData* sessionFactor;

@end

@interface EvelopeCryptoResult : NSObject

@property (nonatomic, strong) NSData* sessionKey;
@property (nonatomic, strong) NSData* sessionIV;
@property (nonatomic, strong) NSData* cryptoData;
@property (nonatomic, assign) NSInteger errorCode;

@end
