//
//  ASSSecureSdk.h
//  APSecSecuritySDK
//
//  Created by xingchen on 15/2/26.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//
#import <Foundation/Foundation.h>

//初始化API的字典参数中,TID的key
//key for TID in the NSDictionary parameter for initToken:callback: API
extern NSString * const ASS_TID;

//初始化API的字典参数中，userid的key
//key for USERID in the NSDictionary parameter for initToken:callback: API
extern NSString * const ASS_USERID;

//初始化API的字典参数中,环境变量的key
//key for server environment configuration in the NSDictionary parameter for initToken:callback: API
extern NSString * const ASS_ENVIRONMENT;

//初始化API的字典参数中，环境变量的value，代表线上环境
//value for server configuration in the NSDictionary parameter for initToken:callback: API, stands for online environment
extern NSString * const ASS_ENVIRONMENT_ONLINE;

//初始化API的字典参数中，环境变量的value，代表测试环境
//value for server configuration in the NSDictionary parameter for initToken:callback: API, stands for test environment
extern NSString * const ASS_ENVIRONMENT_SIT;

//初始化API的字典参数中，环境变量的value，代表开发环境
//value for server configuration in the NSDictionary parameter for initToken:callback: API, stands for daily environment
extern NSString * const ASS_ENVIRONMENT_DAILY;

//初始化API的字典参数中，环境变量的value，代表预发环境
//value for server configuration in the NSDictionary parameter for initToken:callback: API, stands for pre online environment
extern NSString * const ASS_ENVIRONMENT_PRE;

//初始化API的字典参数中,设置RPC网关地址的key。
//key for RPC server gateway address in the NSDictionary parameter for initToken:callback: API.
//If value for this key is specified, the value for ASS_ENVIRONMENT will be ignored.
extern NSString * const ASS_RPC_GATEWAY_ADDR;

//rpc header workspaceid key
extern NSString * const ASS_RPC_WORKSPACEID;

extern NSString * const ASS_RPC_OPERATIONTYPE;

extern NSString * const ASS_RPC_GW_TYPE;

//rpc header appid key
extern NSString * const ASS_RPC_APPID;

//初始化API的字典参数中,设置UMID网关host地址的key。
//host 要设置的线上地址，如ynuf.alipay.com，不要带协议头，不要带后面的参数，只能传纯host地址
//key for UMID server host in the NSDictionary parameter for initToken:callback: API.
//host should only contain online address such as ynuf.alipay.com, without protocol or parameters.
extern NSString* const ASS_UMID_HOST;

//初始化API的字典参数中,设置加密的umid。
extern NSString * const ASS_ENCODE_UMID;

extern NSString * const ASSErrorAppNameNil;

extern NSString* const ASS_LOCATION;

extern NSString* const ASS_X_WEBGW_VERSION;

extern NSString* const ASS_X_WEBGW_APPID;

extern NSString* const ASS_KEY_TENANT_ID;

static NSString* const ASS_GW_WALLET = @"0";

static NSString* const ASS_GW_ALICLOUD = @"1";

static NSString* const ASS_GW_MPAAS = @"2";

/*!
 @typedef ASSStatusCode
 
 Possible return codes
 @constant ASSStatusCodeOk                       Completed, No errors
 @constant ASSStatusCodeInvalidParam             input param invalid
 @constant ASSStatusCodeAppNameNil               appName is nil
 @constant ASSStatusCodeAppKeyNil                appKeyClient is nil
 @constant ASSStatusCodeConnectionError          network connection failure
 */
typedef NS_ENUM(NSInteger, ASSStatusCode)
{
    ASSStatusCodeOk = 0,
    ASSStatusCodeInvalidParam,
    ASSStatusCodeAppNameNil,
    ASSStatusCodeAppKeyNil,
    ASSStatusCodeConnectionError,
    
};

typedef NS_ENUM(NSInteger, ASSAddressFlag)
{
    ASSAddressFlagIndonesia = 1,
    ASSAddressFlagMalaysia  = 2,
    ASSAddressFlagPilipinas = 3,
    ASSAddressFlagSingapore = 4,
    ASSAddressFlagIpayVn    = 11,
    ASSAddressFlagIpayId    = 12,
    ASSAddressFlagIpayMy    = 13,
    ASSAddressFlagIpaySg    = 14,
    ASSAddressFlagIpayTh    = 15,
    ASSAddressFlagIpayPh    = 16,
    ASSAddressFlagIpayDefault = 17,
};

typedef NS_ENUM(NSInteger, Locale) {
    FinTech = 1,
    TinyAppCloud = 2,
};

typedef NS_ENUM(NSInteger, EnvMode) {
    ENV_MODE_ONLINE = 0,
    ENV_MODE_PRE = 1,
    ENV_MODE_SIT = 2,
    ENV_MODE_DAILY = 3,
    ENV_MODE_DEV = 4,
};

@interface APSecureSdkInitParams : NSObject

@property (nonatomic, copy) NSString* fileUploadDelegateImplClass;
@property (nonatomic, copy) NSString* configServiceDelegateImplClass;
@property (nonatomic, copy) NSString* mdapDelegateImplClass;
@property (nonatomic, copy) NSString* logDelegateImplClass;
@property (nonatomic, copy) NSString* rpcDelegateImplClass;
@property (nonatomic, copy) NSDictionary* configuration;

+(NSDictionary*) createConfiguration:(Locale) locale envMode:(EnvMode) envMode;

@end

@interface APSecureSdk : NSObject

/**
 获取单例
 */
+ (id)sharedInstance;

/**
 初始化
 */

- (void)initWithSaas:(NSString *)appName tenantId:(NSString *)tenantId;

- (void)initWithRpcConfiguration:(NSDictionary *) config bizToken: (NSString *) bizToken appName:(NSString *)appName;

- (void)initWithParams:(APSecureSdkInitParams *)params bizToken:(NSString *) bizToken appName:(NSString *)appName;

- (void)setBizToken: (NSString *) bizToken;

- (void)setUserId: (NSString *) uid;

- (void)setRpcConfiguration:(NSDictionary *) config withAppName:(NSString *)appName;

- (void)setFileUploadDelegateImplClass:(id)clazz withAppName:(NSString *)appName;

- (void)setConfigServiceDelegateImplClass:(id)clazz withAppName:(NSString *)appName;

- (void)setMdapDelegateImplClass:(id)clazz withAppName:(NSString *)appName;

- (void)setLogDelegateImplClass:(id)clazz withAppName:(NSString *)appName;

- (void)setRpcDelegateImplClass:(id)clazz withAppName:(NSString *)appName;

+(BOOL) isSupportFaceShield;

@end

/**
 废弃接口，兼容mraas7.x，调用请咨询sdk提供方
 */
@interface APSecureSdk(Deprecated)

- (void) initWithRpcConfiguration:(NSDictionary *) config bizToken:(NSString *) bizToken;

- (void) initWithRpcConfiguration:(NSDictionary *) config;

- (void) setRpcConfiguration:(NSDictionary *) config;



@end
