//
//  APDevSecInfo.h
//  APPSecuritySDK
//
//  Created by qiqing on 2023/6/27.
//  Copyright © 2023 Alipay. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN



@interface APDevSecInfo : NSObject

/**
 * 安全信息获取
 *
 * @param appName 应用标识，对应安全SDK初始化接口中的appName
 * @param timeout 接口超时时间设置，单位为毫秒
 * @param error 接口内部错误返回
 * @return 安全信息结果
 */


+ (NSString*) devSecInfoWithAppName:(NSString*)appName timeout:(NSInteger)timeout error:(NSError **)error;

@end

NS_ASSUME_NONNULL_END

//typedef void(^APPSecurityDevSecInfoCallback)(BOOL success, NSString* result, NSString* errorMsg);
//* @param callback，安全信息结果回调
//+ (void) getDevSecInfo:(NSString*)appName callback:(APPSecurityDevSecInfoCallback)callback;
