//
//  UIImage+APMRequestInfo.h
//  APMultimedia
//
//  Created by 鲁旭 on 2020/8/25.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "APImageCacheRequest.h"
#import "APRegionCutImageRequest.h"
NS_ASSUME_NONNULL_BEGIN

@interface APMImageRequestInfo : NSObject
//业务标识
@property (nonatomic, copy)NSString *bizType;
//资源标识
@property (nonatomic, copy)NSString *identifier;
//请求类型
@property (nonatomic, assign)APImageRequestTypeEnum requestType;
//请求zoom
@property (nonatomic, assign)CGSize zoom;
//裁切请求类型
@property (nonatomic, assign) APMImageCacheType cacheType;
/**
 *  当为横图 从什么区域裁切
 */
@property (nonatomic, assign) APImageCropRegion landscapeCropRegion;

/**
 *  当为竖图 从什么区域裁切
 */
@property (nonatomic, assign) APImageCropRegion portraitCropRegion;

/**
 *  是否支持智能裁切
 */
@property (nonatomic, assign) BOOL enableSmartCropHeadRegionWhenSupport;

/**
 是否支持显著性裁切算法，只有在enableSmartCropHeadRegionWhenSupport为YES的时候生效，做为智能裁切的一种补充，当人脸识别失败的时候，走显著性裁切。 默认为NO
 */
@property (nonatomic, assign) BOOL enableSaliencyCropWhenSmartCropFailed;

@property (nonatomic, assign) BOOL isRegionCutImageRequest;


-(instancetype)initWithAPMImageRequest:(APImageRequest *)imageRequest;

@end


@interface UIImage(APMRequestInfo)

@property (nonatomic, copy) APMImageRequestInfo *requestInfo_ap;

@end

NS_ASSUME_NONNULL_END
