//
//  ImageCacheOptions.h
//  APMultimedia
//
//  Created by Cloud on 2016/10/2.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMMediaCache/APMMediaCache.h>


// 内部的图片类型，比正常多了一个mem
typedef NS_ENUM(NSUInteger, ImageInternalType) {
    ImageInternalTypeScale = 0,     //缩略图
    ImageInternalTypeBig,           //大图
    ImageInternalTypeOriginal,      //原图
    ImageInternalTypeOriginalMem,   //原图裁剪后图
    ImageInternalTypeCrop,          //非等比裁剪文件
};

typedef NS_ENUM(NSUInteger, ImageCropMode) {
    // 区域裁切模式
    ImageCropModeDefault             = 0, // 默认的是MidMid模式
    ImageCropModeLeftTopRegion       = 1,
    ImageCropModeLeftMidRegion       = 2,
    ImageCropModeLeftBottomRegion    = 3,
    ImageCropModeMidTopRegion        = 4,
    ImageCropModeMidMidRegion        = 0,
    ImageCropModeMidBottomRegion     = 5,
    ImageCropModeRightTopRegion      = 6,
    ImageCropModeRightMidRegion      = 7,
    ImageCropModeRightBottomRegion   = 8,
    // 智能裁切
    ImageCropModeSmart               = 9
};

typedef NS_ENUM(NSUInteger, ImageResponseType) {
    ImageResponseTypeImage,
    ImageResponseTypeData,
};

@interface ImageCacheOptions : FileCacheOptions
@property (nonatomic, assign) NSUInteger qValue;
@property (nonatomic, assign) ImageResponseType responseType;
@property (nonatomic, assign) ImageCropMode cropMode;
/**
 降级的裁切模式。当人脸识别失败或者服务器端无法支撑的时候会降级成另外一种策略
 */
@property (nonatomic, assign) ImageCropMode degradeCropMode;

/**
 是否是动态图 主要用于存储图片的场景。对于取图的场景，如果为YES，则说明必须取动态图
 */
@property (nonatomic, assign) BOOL animated;

/**
 对待动态图的策略。主要是取gif图的场景，在取gif的时候 并不能确定id对应的资源是否是gif图
 */
@property (nonatomic, assign) APGifOption gifOption;

@property (assign, nonatomic) BOOL shouldDecompressImage;

@property (nonatomic, assign) CGFloat scale;


@end
