//
//  APMH5Plugin.h
//  APMultimedia
//
//  Created by Kris Tian on 2019/9/26.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface APMH5ImageProcessResult : NSObject

- (NSDictionary<NSString *, NSString *> *)eventTrackingInfo;

@end


@interface APMH5ImagePreProcessResult : APMH5ImageProcessResult

@property (nonatomic, copy) NSString *adaptedImageUrl;

@end


@interface APMH5ImageHttpHeadersProcessResult : APMH5ImageProcessResult

@property (nonatomic, copy) NSDictionary<NSString *,NSString *> *h5CompatibleHttpHeaders;

@end


@interface APMH5ImagePostProcessResult : APMH5ImageProcessResult

@property (nonatomic, copy) NSData *h5CompatibleImageData;

@end


@interface APMH5ImagePlugin : NSObject


/// 是否需要经过多媒体前后出炉
/// @param url  原始的url
/// @param bizType 业务标志
+ (BOOL)canAdaptedUrl:(NSString *)url bizType:(NSString *)bizType;
/**
 根据url和biztype来获取优化后的URL。 如果能能优化则返回优化后的url，否则返回原始URL。

 @param url 原始的url
 @param bizType 业务标志
 @return  根据url和biztype来获取优化后的URL。 如果能能优化则返回优化后的url，否则返回原始URL。

 */
+ (APMH5ImagePreProcessResult *)getAdaptedImageUrlWithOriginlUrl:(NSString *)url bizType:(NSString *)bizType;

/**
 根据原始的data数据，返回H5兼容的Image data数据。如果已经是H5兼容的image data，直接返回原始数据，如果是H5不能兼容的图片数据，尝试转换成当前H5兼容的图片数据，如果无法转换或者非图片数据，直接返回原始数据

 @param data 原始的data数据
 @param httpContentType  期望返回的data数据类型
 @param httpHeaders 经过后处理的header
 @param url 传入前处理后的url
 @return 根据原始的data数据，返回H5兼容的Image data数据
 */
+ (APMH5ImagePostProcessResult *)getH5CompatibleImageDataWithOriginalData:(NSData *)data
                                                          withContentType:(NSString *)httpContentType
                                                                      url:(NSString *)url
                                                                  bizType:(NSString *)bizType;

+ (APMH5ImagePostProcessResult *)getH5CompatibleImageDataWithOriginalData:(NSData *)data
                                                          withContentType:(NSString *)httpContentType;

+ (APMH5ImagePostProcessResult *)getH5CompatibleImageDataWithOriginalData:(NSData *)data
                                                          withContentType:(NSString *)httpContentType
                                                               withHeader:(NSDictionary *)httpHeaders
                                                                      url:(NSString *)url
                                                                  bizType:(NSString *)bizType;


/// 原始url Http Header处理，可能包含浏览器无法支持的图片格式Http Header和body做进一步处理，当前的接口处理Http Header，返回包含H5兼容的图片格式的Http header
/// @param httpHeaders 服务器端返回的原始Http header
/// @param url 原始url
/// @param bizType 业务标志
+ (APMH5ImageHttpHeadersProcessResult *)h5CompatibleHttpHeaders:(NSDictionary *)httpHeaders
                                                            url:(NSString *)url
                                                        bizType:(NSString *)bizType;

+ (APMH5ImageHttpHeadersProcessResult *)h5CompatibleHttpHeaders:(NSDictionary *)httpHeaders;

@end

