//
//  APMapService.h
//  APMap
//
//  Created by Wanlei on 14-5-4.
//  Copyright (c) 2014年 Alipay. All rights reserved.
//



#import <CoreLocation/CoreLocation.h>

#ifndef BUILD_FOR_MPAAS
#import <APMobileFramework/APMobileFramework.h>
#endif

@protocol APMapGeoCode;
@protocol APMapReGeoCode;
@protocol APMapRoad;
@protocol APMapRoadInter;
@protocol AMapMpaasPOI;
@class AMapMpaasPOI;




@interface APMapGeoRequest : NSObject
/**
 * 查询地址
 */
@property(nonatomic, strong) NSString *address;
@end


@protocol APMapGeoResponse  <NSObject>
/**
 * 返回结果数目。通常返回一个结果,但是在进行模糊地址查询时,可能会返回多个结果。
 */
@property(nonatomic, assign) int count;

/**
 * 地理编码信息列表
 */
@property(nonatomic, strong) NSArray  <APMapGeoCode> *geocodes;
@end





@interface APMapReGeoRequest : NSObject
/**
 * 应用Key，标示业务方，用来服务端统计使用
 */
@property(nonatomic, strong) NSString *appKey;

/**
 * 经纬度
 */
@property(nonatomic, assign) CLLocationCoordinate2D coordinate;

/**
 * 查询半径
 */
@property(nonatomic, assign) CGFloat radius;
/**
 *  请求定位信息等级（默认是城市）
 */
@property(nonatomic) CGFloat areaLevel;

/**
 * FIXME 临时解决首页rpc同步定位超时需求，有正式方案后去掉这段
 */
@property(nonatomic,assign)NSTimeInterval timeOut;

@end


@protocol APMapReGeoResponse <NSObject>
/**
 * 忽略此参数，为保持和LBS一致先保留。
 */
@property(nonatomic, assign) int count;

/**
 * 逆向地理编码信息列表
 */
@property(nonatomic, strong) id <APMapReGeoCode> regeocode;

/**
 * 逆向地理编码信息列表
 */
@property(nonatomic, strong) id <APMapReGeoCode> reGeocode;

/**
 * POI信息，只有在调用reGeoCodeAll时返回
 */
@property(nonatomic, strong) NSArray <AMapMpaasPOI> *pois;

/**
 * 道路信息，只有在调用reGeoCodeAll时返回
 */
@property(nonatomic, strong) NSArray <APMapRoad> *roads;

/**
 * 道路交回，只有在调用reGeoCodeAll时返回
 */
@property(nonatomic, strong) NSArray <APMapRoadInter> *roadInters;

/**
 * 完整格式化地址信息
 */
@property(nonatomic, strong) NSString* formatAddress;
@end





#ifdef BUILD_FOR_MPAAS
@protocol APMapService
#else
@protocol APMapService <DTService>
#endif
/**
 * 通过GeoRequest完成地理编码
 * @param request
 * @return
 */
-(void)geoCode:(APMapGeoRequest*)geoRequest completion:(void(^)(id <APMapGeoResponse> result, NSError **error))completion;


/**
 *  通过ReGeoRequest完成逆地理编码，设置areaLevel来请求不同精度的地理位置，默认是city level
 *
 *  @param reGeoRequest
 *  @param completion   
 */
-(void)reverse:(APMapReGeoRequest*)reGeoRequest completion:(void(^)(id <APMapReGeoResponse> result, NSError *error))completion;

/**
 * 通过coordinate计算两个点的距离 (in meters)
 * @param request
 * @return
 */
-(CLLocationDistance)distanceFromLocatin:(CLLocationCoordinate2D)coordinate1 toLocation:(CLLocationCoordinate2D)coordinate2;




@end
