//
//  ThumbnailGenerator.h
//  APMultimedia
//
//  Created by Cloud on 15/7/13.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
/**设置对抽帧时间的容忍度，影响抽帧耗时
 测试抽帧耗时排序为(iphone 7s  960x544, 794 kb/s  30帧):
 APMTimeToleranceBefore|APMTimeToleranceAfter(476ms) > APMTimeToleranceBefore(234ms) > APMTimeToleranceAfter (205ms)> APMTimeToleranceDefault (185ms)
 */
typedef NS_OPTIONS(NSUInteger, APMTimeToleranceOptions) {
    APMTimeToleranceDefault = 0 << 0, //默认不做任何参数设置，耗时最小
    APMTimeToleranceBefore = 1 << 1,  //设置后向容忍时间为 kCMTimeZero
    APMTimeToleranceAfter = 1 << 2    //设置前向容忍时间为 kCMTimeZero
};

@interface APMThumbnailGenerator : NSObject
/**
  从video中提取指定时间范围内指定数量的UIImage

 @param asset                       含video的AVAsset
 @param startPoint            起始时间
 @param endPoint                终止时间
 @param count                       UIImage数量
 @param size                         返回UIImage最大size 特别注意: size单位: 点 不是像素
 @param options                   抽取时间准确性的容忍选项
 @param handler                  提取回调，每生成UIImage回调一次
 */
+ (void)generateThumbnailsFromAVAsset:(AVAsset *)asset
                           startPoint:(NSTimeInterval)startPoint
                             endPoint:(NSTimeInterval)endPoint
                                count:(NSUInteger)count
                                 size:(CGSize)size
                              options:(APMTimeToleranceOptions)options
                      completeHandler:(void (^)(UIImage *thumbnail, NSError *error, NSTimeInterval requestedTime))handler;

//注意:此接口为兼容老逻辑,默认options为:APMTimeToleranceBefore|APMTimeToleranceAfter
+ (void)generateThumbnailsFromAVAsset:(AVAsset *)asset
                           startPoint:(NSTimeInterval)startPoint
                             endPoint:(NSTimeInterval)endPoint
                                count:(NSUInteger)count
                                 size:(CGSize)size
                      completeHandler:(void (^)(UIImage *thumbnail, NSError *error, NSTimeInterval requestedTime))handler;

/**
 从video中提取首帧图
 
 @param asset                       含video的AVAsset
 @param size                         返回UIImage最大size 特别注意: size单位: 点 不是像素
 @param options                   抽取时间准确性的容忍选项
 @param handler                   获取首帧图回调
 */
+ (void)generateThumbnailFromAVAsset:(AVAsset *)asset
                                 size:(CGSize)size
                             options:(APMTimeToleranceOptions)options
                      completeHandler:(void (^)(UIImage *thumbnail, NSError *error))handler;

+ (void)generateThumbnailFromAVAsset:(AVAsset *)asset
                                 size:(CGSize)size
                      completeHandler:(void (^)(UIImage *thumbnail, NSError *error))handler;

@end
