//
//  APMapCommonMapView.h
//  APMap
//
//  Created by 去疾 on 17/3/27.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <APMap/APMapCommonMapMarker.h>
#import <APMap/APMapCommonMapPolyline.h>
#import <APMap/APMapCommonMapCircle.h>
#import <APMap/APMapCommonMapControl.h>
#import <APMap/APMapCommonMapPolygon.h>
#import <APMap/APMapCommonTileOverLay.h>
#import <APMap/APMapCommonMapTranslateMarker.h>

@class AMMoveMarkerModel;
@class APMapCommonMapView;
@class APMapCommonMapMarkerView;

typedef void(^APMapCommonMapViewBlock)(NSDictionary* data);
typedef void(^APMapRouteLineBlock)(NSDictionary* data);
typedef void(^APMapTranslateMarkerBlock)(NSDictionary* data);
typedef void(^APMapSmoothMoveMarkerBlock)(NSDictionary* data);
typedef void(^APMapSmoothMovePolylineBlock)(NSDictionary* data);

/**
 *
 *  支持小程序的通用地图组件
 *
 */


@protocol APMapCommonMapViewDelegate <NSObject>
@optional
- (void)apMapCommonMapViewDidMarkerAdd:(id <MAAnnotation>)marker;
- (void)apMapInitComplete:(APMapCommonMapView *)mapView;

@end

@interface APMapCommonMapView : UIView

@property(nonatomic, assign) CGFloat scale;
@property(nonatomic, assign) CLLocationDegrees latitude;
@property(nonatomic, assign) CLLocationDegrees longitude;
@property(nonatomic, assign) BOOL showLocation;
@property(nonatomic, copy) NSString *appId;
@property(nonatomic, assign) CGFloat rotationDegree;
@property(nonatomic, assign) CGFloat cameraDegree;
@property(nonatomic, strong) NSArray *limitRegion;
@property(nonatomic, assign) BOOL allowsAnnotationViewSorting;

@property(nonatomic, strong) NSArray<APMapCommonMapMarker*> *markers;
@property(nonatomic, strong) NSArray<APMapCommonMapPolyline*> *polyline;
@property(nonatomic, strong) NSArray<APMapCommonMapCircle*> *circles;
@property(nonatomic, strong) NSArray<APMapCommonMapControl*> *controls;
@property(nonatomic, strong) NSArray<APMapCommonMapPolygon*> *polygon;


@property(nonatomic, strong) NSArray<NSDictionary*> *incluePoints;
@property(nonatomic, assign) UIEdgeInsets includePadding;

@property(nonatomic, copy) APMapCommonMapViewBlock markerTappedBlock;
@property(nonatomic, copy) APMapCommonMapViewBlock controlTappedBlock;
@property(nonatomic, copy) APMapCommonMapViewBlock regionChangedBlock;
@property(nonatomic, copy) APMapCommonMapViewBlock tappedBlock;
@property(nonatomic, copy) APMapCommonMapViewBlock calloutTappedBlock;
@property(nonatomic, copy) APMapCommonMapViewBlock translateMarkerEndBlock;

@property(nonatomic, weak) id<APMapCommonMapViewDelegate> delegate;

@property(nonatomic, strong) NSMutableArray *rangeDisplayAnnotatoins;
@property(nonatomic, strong) NSDictionary *markerClusterSetting;
-(id)initWithAppId:(NSString *)appId;

-(id)initWithFrame:(CGRect)frame appId:(NSString *)appId;


-(void)moveToLocation;

-(CLLocationCoordinate2D)getCenterLocation;

-(void)gestureEnable:(BOOL)yesOrNo;

-(void)showsScale:(BOOL)yesOrNo;

-(void)showsCompass:(BOOL)yesOrNo;

-(void)showsTraffic:(BOOL)yesOrNo;

-(void)showsLabels:(BOOL)yesOrNo;

-(void)changeLogoPosition:(CGPoint)point;

-(void)rotateCameraEnabled:(BOOL)yesOrNo;

-(void)showAnimateWithMarkerData:(NSInteger)markerId;

-(void)showRouteLineWithOriginX:(CGFloat)originX
                        OriginY:(CGFloat)originY
                          destX:(CGFloat)destX
                          destY:(CGFloat)destY
                          width:(CGFloat)width
                          color:(UIColor*)color
                          image:(UIImage*)image
                     routeLevel:(MAOverlayLevel)routeLevel
                       callBack:(APMapRouteLineBlock)callBack;

-(void)showRouteLineWithOriginX:(CGFloat)originX
                        OriginY:(CGFloat)originY
                          destX:(CGFloat)destX
                          destY:(CGFloat)destY
                          width:(CGFloat)width
                          color:(UIColor*)color
                          image:(UIImage*)image
                     searchType:(NSString*)searchType
                           mode:(NSInteger)mode
                           city:(NSString *)city
                destinationCity:(NSString *)destinationCity
                  throughPoints:(NSArray *)throughPoints
                     routeLevel:(MAOverlayLevel)routeLevel
                       callBack:(APMapRouteLineBlock)callBack;

- (void)clearRouteLine;

- (void)showTranslateMarker:(NSInteger)markerId markerData:(APMapCommonMapTranslateMarker *)markerData callback:(APMapTranslateMarkerBlock)callback;

- (void)showSmoothMoveMarkerAnimate:(AMMoveMarkerModel *)markerData callback:(APMapSmoothMoveMarkerBlock)callback;

- (void)stopSmoothMoveMarkerAnimate:(NSString *)markerId callback:(APMapSmoothMoveMarkerBlock)callback;

- (void)showSmoothMovePolylineAnimate:(APMapCommonMapPolyline *)polylineData callback:(APMapSmoothMovePolylineBlock)callback;

- (void)stopSmoothMovePolylineAnimate:(NSString *)polylineId callback:(APMapSmoothMovePolylineBlock)callback;

/**
 *  为支持fallback异步加载marker的icon，需要得到icon后逐个setIcon，直接修改Icon在mapview上不生效
 *
 *  @param marker annotation
 */
- (void)setMarker:(APMapCommonMapMarker *)marker;

- (void)setMarkers:(NSArray<APMapCommonMapMarker *> *)markers;

/**
 *  为支持fallback异步加载overLay的icon，需要得到icon后逐个setIcon，直接修改Icon在mapview上不生效
 *
 *  @param groundOverLay
 */
- (void)setGroundOverLay:(MAGroundOverlay *)overLay level:(MAOverlayLevel)level;

/**
 *  @param tileOverLay
 */
- (void)setTileOverLay:(APMapCommonTileOverLay *)overLay;

/**
 *  清除所有markers，在每次产生新的markers前调用
 */
- (void)clearMarkers;

- (void)removeAnnotation:(id <MAAnnotation>)annotation;

/**
 *  清除所有groundOverLay，在每次产生新的groundOverLay前调用
 */
- (void)clearOverLays;

- (void)clearGroundOverLay;

- (void)clearTileOverLay;

- (void)changeMapCenterWithLatitude:(CLLocationDegrees)latitude longitude:(CLLocationDegrees)longitude;

- (CGFloat)getMapViewZoomLevel;

/**
 *  自定义地图样式
 */
- (void)setCustomMapStyle:(NSString *)styleName;

- (BOOL)setPolylineWithCoordinates:(CLLocationCoordinate2D *)coords count:(NSInteger)count;

- (void)addPolyline:(NSArray<APMapCommonMapPolyline*> *)polyline;

- (APMapCommonMapMarker *)findAnnotationWithId:(NSString *)annotationId;

- (void)setCameraDegree:(CGFloat)degree animated:(BOOL)animated duration:(CFTimeInterval)duration;

- (void)buildTreeWithMarkers:(NSArray *)markers;

- (void)updateClusterMarkers;

- (void)updateDisplayRangeMarkers;

- (APMapCommonMapMarkerView *)viewForAnnotation:(APMapCommonMapMarker *)annotation;
@end
