//
//  APVideoPlayerSetting.h
//  APMultimedia
//
//  Created by 慎一 on 2017/1/12.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface APVideoPlayerSetting : NSObject

/**
 音频播放器下载完成是否缓存 默认缓存
 */
@property (nonatomic, assign) BOOL shouldCacheAfterDownloadForAudio;

/**
 视频播放器下载完成是否缓存 默认缓存
 */
@property (nonatomic, assign) BOOL shouldCacheAfterDownloadForVideo;


/**
 网络下载超时时间 单位为秒 默认360s
 */
@property (nonatomic, assign) int  downloadTimeout; //网络下载超时时间


/**
  网络加载meta信息的超时时间 如果这个时间内 没有获取到 会中止请求。 单位为s 默认30s。
 */
@property (nonatomic, assign) int  metaInfoTimeout;//加载meta信息的超时时间


/**
 最大缓存文件大小，超过这个大小 不存缓存，单位为M 默认50M
 */
@property (nonatomic, assign) int maxCacheSize;


/**
 当seek请求和已有数据 间隔多大的时候 重新发送请求，单位为M 默认0.3M
 */
@property (nonatomic, assign) float newRequestSize;

//当处在loading状态的时候，当laodedTime比watchedTime时间间隔大于这个值的时候，主动去播放，单位为秒，默认为3s；
@property (nonatomic, assign) NSUInteger maxTimeIntervalWhenLoading;

/**
  压缩视频的时候 是否对网络进行优化,默认为YES
 */
@property (nonatomic, assign) BOOL shouldOptimizeWhenCompress;


/**
 拖动视频的时候 是否精准,默认为YES
 */
@property (nonatomic, assign) BOOL enableAccurateSeek;


/**
 当已经存在部分缓存的时候 比如15M，全部给播放器 会导致播放失败，需要一部分一部分的给播放器，单位为byte，默认3*1024*1024
 */
@property (nonatomic, assign) long long maxPacketDataLength;


/**
 网络组进度更新的时候，只有相对上次更新字节数，大于某一个阀值才会通知播放器。避免频繁的读取文件，节省CPU。 单位为byte，默认16*1024
 */
@property (nonatomic, assign) long long miniPacketUpdateThreshold;


/**
 网络组进度更新的时候，只有相对上次更新时间，大于某一个阀值才会通知播放器。避免频繁的读取文件，节省CPU。 单位为秒，默认0.1s
 */
@property (nonatomic, assign) float miniTimeUpdateThreshold;


/**
 视频播放 碰到下面错误的时候，需要清理对应资源的缓存信息。默认位@[@(AVErrorFileFailedToParse),@(AVErrorUnknown)]
 */
@property (nonatomic, copy) NSArray *errorCodesNeedCleanCache;


/**
 对django视频资源是否支持边下边播做探测，默认django视频资源都支持边下边播，不用做探测
 */
@property (nonatomic, assign) BOOL detectRangeSupportForCloudID;


@property (nonatomic,copy) NSArray *supportVideoUrlAndThumbnaiBusiness;

@property (nonatomic,assign) float timeIntervalForUnexpectedEndNotification;

@property (nonatomic, assign) BOOL tryRefreshSessionWhenAuthFailed;

@property (nonatomic, assign) BOOL triggerWithTimer;

@property (nonatomic, assign) BOOL checkDataBeforeCached;

@property (nonatomic, assign) BOOL checkTaskStatus;

@property (nonatomic, assign) BOOL stopPlayerWhenErrorOccurred;

@property (nonatomic, assign) BOOL enablePreloadData;

@property (nonatomic, assign) BOOL enableDefaultContentType;

@property (nonatomic, assign) BOOL enableRemoteLogReport;
/**
 多长时间间隔没有数据就会重新发送请求
 */
@property (nonatomic, assign) NSUInteger timeIntervalForNoDataUpdateRetryRequest;
/**
 *  共享对象
 *
 *  @return 共享的对象
 */
+ (instancetype)shareInstance;

/**
 *  使用sharedInstance，别用init
 *
 *  @return 对象
 */
- (instancetype)init __attribute__((unavailable("init not available")));

- (BOOL)useSystemResourceLoaderWithBizType:(NSString *)bizType;

- (BOOL)shouldRecoverFromMediaSerivcesResetWithBizType:(NSString *)bizType;

@end
