//
//  VoiceCache2.h
//  APMMediaCache
//
//  Created by 鲁旭 on 2020/2/28.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "FileCache2.h"
NS_ASSUME_NONNULL_BEGIN

typedef enum : NSUInteger {
    VoiceCacheEncoded = 0,
    VoiceCacheDecoded = 1,
    VoiceCacheSilk = VoiceCacheEncoded,     //Silk格式音频
    VoiceCacheWave = VoiceCacheDecoded,         //Wave格式音频
} VoiceCacheType;

@interface VoiceCache2 : FileCache2

- (void)setObject:(id<NSCoding>)object forKey:(NSString *)key duration:(NSInteger)duration type:(VoiceCacheType)type options:(FileCacheOptions *)options;
- (id<NSCoding>)objectForKey:(NSString *)key type:(VoiceCacheType)type;

- (NSString *)objectPathForKey:(NSString *)key type:(VoiceCacheType)type checkExist:(BOOL)checkExist;
@end

NS_ASSUME_NONNULL_END
