//
//  FileCache2.h
//  APMultimedia
//
//  Created by Cloud on 16/8/12.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APMCacheType.h"
#import "APMCacheTag.h"
#import <APMCache/APMCache.h>

#define APM_CACHE_HIT_BEGIN() \
    CFAbsoluteTime hitStart = CFAbsoluteTimeGetCurrent();

#define APM_CACHE_HIT_END(OBJECT, TYPE) \
    { \
        CFAbsoluteTime hitEnd = CFAbsoluteTimeGetCurrent(); \
        [self.counter hitCache:(OBJECT ? YES : NO) type:TYPE timeInterval:hitEnd - hitStart]; \
    }

#define CREATE_DEFAULT_CACHE            \
    + (instancetype)defaultCache {          \
        static dispatch_once_t onceToken;   \
        static id instance;                 \
        dispatch_once(&onceToken, ^{        \
            instance = [[self alloc] initWithName:@"com.alipay.multimedia"]; \
            if (!instance) {                \
                APM_ERROR(@"failed to init cache"); \
            }                               \
        });                                 \
        return instance;                    \
    }

typedef NS_OPTIONS (NSUInteger, CacheType) {
    CacheTypeNone = 0,
    CacheTypeMemory = 1 << 0,
    CacheTypeDisk = 1 << 1,
    CacheTypeDefault = CacheTypeMemory | CacheTypeDisk,
};

@interface FileCacheOptions : NSObject
@property (nonatomic, strong) NSString *business;
@property (nonatomic, assign) CacheType cacheType;
@property (nonatomic, assign) APMCacheTag tag;
@property (nonatomic, strong) NSString *encryptKey; // 加密的密钥
@property (nonatomic, assign) int expirationTime; // 过期时间，unix时间戳，0表示永不过期，默认为0
@end

@interface FileCache2 : NSObject {
    APMCacheType _type;
}

@property (nonatomic, strong, readonly) APMDiskCache *diskCache;
@property (nonatomic, strong, readonly) APMMemoryCache *memoryCache;

+ (instancetype)defaultCache;
- (instancetype)initWithName:(NSString *)name;

- (void)setObject:(id<NSCoding>)object forKey:(NSString *)key options:(FileCacheOptions *)options;
- (BOOL)setObject:(id)object forKey:(NSString *)key uuid:(NSString *)uuid options:(FileCacheOptions *)options;

// 路径必须是缓存这边生成的路径
- (BOOL)setObjectWithPath:(NSString *)path forKey:(NSString *)key options:(FileCacheOptions *)options;

- (BOOL)containsObjectForKey:(NSString *)key;
- (id<NSCoding>)objectForKey:(NSString *)key;
- (NSString *)objectPathForKey:(NSString *)key checkExistence:(BOOL)checkExistence;

- (void)removeAllObjects;
- (void)removeObjectForKey:(NSString *)key;

- (NSString *)aliasKeyForKey:(NSString *)key;
- (NSString *)businessForKey:(NSString *)key;
- (void)updateBusiness:(NSString *)business forKey:(NSString *)key;
- (void)updateAliasKey:(NSString *)aliasKey forKey:(NSString *)key;
- (void)updateAliasKey:(NSString *)aliasKey business:(NSString *)business forKey:(NSString *)key;
- (void)addTag:(APMCacheTag)tag forKey:(NSString *)key;
- (void)removeTag:(APMCacheTag)tag forKey:(NSString *)key;

- (NSString *)temporaryCachePath;
- (NSString *)rootCachePath;
- (NSString *)generatePathForKey:(NSString *)key;
- (int64_t)totalCost; // 对应类型的缓存总大小

@end
