//
//  CacheSetting.h
//  APMultimedia
//
//  Created by Cloud on 2017/6/21.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface CacheSetting : NSObject

/**
 * 最大缓存大小 单位:byte
 */
@property (nonatomic, assign) int64_t maxCacheSize;

/**
 受保护的资源最大缓存大小
 */
@property (nonatomic, assign) int64_t protectedBusinessMaxCacheSize;


/**
 * 内存缓存上限 单位:byte
 */
@property (nonatomic, assign) NSUInteger memoryCacheLimit;
@property (nonatomic, assign) NSUInteger memoryCacheAgeLimit;
@property (nonatomic, assign) NSUInteger highPriorityMemoryCacheLimit;
@property (nonatomic, assign) NSUInteger highPriorityMemoryCacheAgeLimit;
@property (nonatomic, assign) NSUInteger cleanMemoryInterval;
@property (nonatomic, strong) NSArray *highPriorityBusinesses;

/**
 * 清除间隔时间 单位:s
 */
@property (nonatomic, assign) long cleanInterval;

/**
 * 存储空间满处理时间间隔  单位s
 */
@property (nonatomic, assign) long storageWarnInterval;

/**
 * 存储空间满清除缓存大小 单位byte
 */
@property (nonatomic, assign) int64_t storageWarnCleanSize;

/**
 * 是否自动清理超过存储阈值的存储， 0不自动清理，1自动清理
 */
@property (nonatomic, assign) int autoClean;


/**
 * 自动清理额外清理缓存大小, 单位byte. 默认30 * 1024 *1024
 */
@property (nonatomic, assign) int64_t extraAutoCleanSize;

/**
 * 清理业务存储的有效时间，UCT时区
 */
@property (nonatomic, assign) long long validTimeToCleanBusiness;

/**
 * 清理UCT时区前的业务类型的存储，key为business，value为uct时区的时间
 */
@property (nonatomic, strong) NSDictionary *cleanBusinessDict;

/**
 *  缓存存储埋点业务白名单
 */
@property (nonatomic, strong) NSArray* storeCacheBusiArray;

/**
 *  缓存中的ids需要清理，
 */
@property (nonatomic, strong) NSArray* cleanIDsArray;


/**
 *  手动清理开关
 */
@property (nonatomic, assign) BOOL manuCleanSwitch;

/**
 *  共享对象
 *
 *  @return 共享的对象
 */
+ (instancetype)sharedInstance;

/**
 *  使用sharedInstance，别用init
 *
 *  @return 对象
 */
- (instancetype)init __attribute__((unavailable("init not available")));

/**
 *  缓存存储成功率埋点白名单配置
 *
 *  @param business
 *
 *  @return YES:NO
 */
- (BOOL)isRemoteOpenWithBusiType:(NSString*)business;

- (BOOL)isHighPriorityBusinessesWithBusiness:(NSString*)business;

@end
