//
//  APCacheCounter.h
//  APMultimedia
//
//  Created by 慎一 on 16/9/10.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APMCacheType.h"

#define CREATE_DEFAULT_CACHE_COUNTER        \
    + (instancetype)sharedInstance {        \
        static dispatch_once_t onceToken;   \
        static id instance;                 \
        dispatch_once(&onceToken, ^{        \
            instance = [[self alloc] init]; \
            if (!instance) {                \
                APM_ERROR(@"failed to init cache counter"); \
            }                               \
        });                                 \
        return instance;                    \
    }

typedef NS_ENUM (NSUInteger, APCacheHitType) {
    APCacheHitTypeMem, //命中内存
    APCacheHitTypeDisk,//直接命中磁盘
    APCacheHitTypeDB,//通过数据库获取或者是裁切
};

@interface APCacheCounter : NSObject

/**
 *  时间间隔内 内存命中次数
 */
@property (nonatomic, readonly) NSInteger memHitTotalCount;

/**
 *   时间间隔内 内存命中花费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval memHitTotalTimeInterval;

/**
 *  时间间隔内 内存没有命中次数
 */
@property (nonatomic, readonly) NSInteger memNotHitTotalCount;

/**
 *  时间间隔内 内存没命中话费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval memNotHitTotalTimeInterval;

/**
 *  时间间隔内 磁盘命中次数
 */
@property (nonatomic, readonly) NSInteger diskHitTotalCount;

/**
 *  时间间隔内 磁盘命中花费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval diskHitTotalTimeInterval;

/**
 *  时间间隔内 磁盘没命中次数
 */
@property (nonatomic, readonly) NSInteger diskNotHitTotalCount;

/**
 *  时间间隔内 磁盘没命中花费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval diskNotHitTotalTimeInterval;



/**
 *  时间间隔内 db命中次数
 */
@property (nonatomic, readonly) NSInteger dbHitTotalCount;

/**
 *   时间间隔内 db命中花费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval dbHitTotalTimeInterval;

/**
 *  时间间隔内 db没命中次数
 */
@property (nonatomic, readonly) NSInteger dbNotHitTotalCount;

/**
 *   时间间隔内 db没命中花费的总时间
 */
@property (nonatomic, readonly) NSTimeInterval dbNotHitTotalTimeInterval;

/**
 *  缓存存储相关参数
 */
@property (nonatomic, readonly) NSInteger storeResult;

@property (nonatomic, readonly) NSInteger dataSize;

@property (nonatomic, readonly) BOOL isNetData; //是否网络数据，或者是本地裁剪

@property (nonatomic, readonly) NSString* business;

@property (nonatomic, readonly) NSString* type;

@property (nonatomic, readonly) NSError* error;

/**
 *  缓存命中埋点时间间隔，默认2分钟
 */
@property (nonatomic) NSInteger hitCachesTimeInterval;

/**
 *  缓存存储埋点时间间隔，默认5秒钟
 */
@property (nonatomic) NSInteger storeCachesTimeInterval;

+ (instancetype)sharedInstance;
/**
 *  记录一次缓存查询情况
 *
 *  @param hit          是否命中缓存
 *  @param cachetype    缓存类型APCacheHitType
 *  @param timeInterval 花费的时间
 */
- (void)hitCache:(BOOL)hit type:(APCacheHitType)cachetype timeInterval:(NSTimeInterval)timeInterval;


- (void)storeCacheRecord:(BOOL)result type:(APMCacheType)type object:(id)object isNetData:(BOOL)isNet business:(NSString*)business error:(NSError*)error;

@end
