//
//  APNGImageParse.h
//  APMImageProcessing
//
//  Created by Monster on 2020/12/9.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface APNGImageFrameInfo : NSObject
@property(nonatomic, assign)NSUInteger width;
@property(nonatomic, assign)NSUInteger height;
@property(nonatomic, strong)NSData* data;
@end


@interface APNGImageParse : NSObject

@property(nonatomic, assign, readonly)NSUInteger frameCount;
@property(nonatomic, assign, readonly)double totalDuration;
@property(nonatomic, strong, readonly)NSArray<UIImage*>* images;
@property(nonatomic, assign)NSUInteger playCount;
@property(nonatomic, assign)BOOL freeze;//是否需要定格在最后一帧

+ (BOOL)isAPNGWithData:(NSData*)data;

- (instancetype)initWithData:(NSData*)data;

- (UIImage*)imageWithTimestamp:(double)timeStamp;

- (APNGImageFrameInfo*)imageFrameInfoWithTimestamp:(double)timeStamp;
@end

