#ifndef image_ImageHelper_h
#define image_ImageHelper_h


/*
 * The MIT License
 *
 * Copyright (c) 2011 Paul Solt, PaulSolt@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#import <Foundation/Foundation.h>
#import <UIKit/UIImage.h>
#import <UIKit/UIScreen.h>


typedef enum : NSUInteger {
    ImageHelperColorSpaceRGBA8,
    ImageHelperColorSpaceABGR8,
    ImageHelperColorSpaceRGBA8_NonPremultipliedAlpha,
    ImageHelperColorSpaceABGR8_NonPremultipliedAlpha,
} ImageHelperColorSpaceEnum;


@interface APMPImageHelper : NSObject {

}


/** Converts a UIImage to RGBA8 bitmap.
   @param image - a UIImage to be converted
   @return a RGBA8 bitmap, or NULL if any memory allocation issues. Cleanup memory with free() when done.
 */
+ (CGContextRef)newBitmapContextWithNoMemcpyFromImage:(UIImage *)image colorSpace:(ImageHelperColorSpaceEnum)colorSpace;


/** A helper routine used to convert a RGBA8 to UIImage
   @return a new context that is owned by the caller
 */
+ (CGContextRef)newBitmapContextFromImage:(CGImageRef)image colorSpace:(ImageHelperColorSpaceEnum)colorSpace;

/** Converts a bitmap to a UIImage.
   @param buffer - the RGBA8 unsigned char * bitmap
   @param width - the number of pixels wide
   @param height - the number of pixels tall
   @return a UIImage that is autoreleased or nil if memory allocation issues
 */
+ (UIImage *)convertBitmapToUIImage:(unsigned char *)buffer
                          withWidth:(int)width
                         withHeight:(int)height
                           isMirror:(BOOL)isMirror
                         colorSpace:(ImageHelperColorSpaceEnum)colorSpace;

+ (unsigned char*)convertUIImageToBitmap:(UIImage *)image colorSpace:(ImageHelperColorSpaceEnum)colorSpace;


+ (UIImage*)scaleAndRotateImage:(UIImage*)image
                          andMax:(NSInteger)size;

@end


#endif
