#ifndef _IHEVCD_WRAPPER_H_
#define _IHEVCD_WRAPPER_H_

#ifdef __cplusplus
extern "C" {
#endif
//-------------------------
//  Reis 201705
//-------------------------


typedef enum {
    HEVCD_STATUS_SUCCESS=0,
    HEVCD_STATUS_NEEDSTREAM,
    HEVCD_STATUS_NEEDFLUSH,
    HEVCD_STATUS_NOMEMORY,
    HEVCD_STATUS_NOTSUPPORTED,
    HEVCD_STATUS_EOF,
    HEVCD_STATUS_INVALID_PARAMS,
    HEVCD_STATUS_OPEN_FAILED,
    HEVCD_STATUS_UNKNOWN=100,
 } HEVCDStatus;

#define HEVCD_VERSION 0x03

enum {
    HEVCD_FMT_YUV420P=0,
    HEVCD_FMT_YUV420SP,
    HEVCD_FMT_RGBA8888,
    HEVCD_FMT_YUV444P,
};

typedef struct {
    unsigned char *data;
    int         len;				// input total bytes
    int         inp_finish;         //input data finish or not
    unsigned int consumed;		// consumed bytes
    unsigned char *alpha_bs;
    int alpha_len;
    int frame;
    
    unsigned char *yuvbs_start;
    unsigned char *alphabs_start;
    int yuvbs_len;
    int alphabs_len;
    unsigned int *pi_header;
} avpkt_t;
    
typedef  enum{
    PICTURE = 0,
    PICTURE_HEVC = 1,
    PICTURE_HEVC_HEVC = 2,
    PICTURE_SCC = 3,
    PICTURE_SCC_SCC = 4,
    ANIMATION = 5,
} AHPtype;

 typedef struct {
     unsigned int width;
     unsigned int height;
     unsigned int min_input_len;
     unsigned int min_output_len;
     unsigned int output_fmt;
     
     unsigned short version;
     AHPtype ahp_type;
     unsigned int with_alpha;
     unsigned int reserved;
     int yuv_offset;
     int alpha_offset;
     
     int loop_cnt;
     int entry;
     int frame_cnt;
     
     unsigned int pic_type;
     unsigned int poc;
 } vframeInfo_t;

typedef struct {
    unsigned char* data;
    unsigned char* rgba_data;
    unsigned char* alpha_data;
    unsigned int len;
    int delay;
    int last_frame;
    vframeInfo_t info;
} vframe_t;


typedef struct {
    unsigned int u4_num_cores;
    unsigned int u4_decode_image; // 1 indicate image decode, 2 indicate animation decode, 0 indicate video decode
    unsigned int output_fmt;
    int ahp_header;
    int i4_seq_mode;
} hevcd_init_param_t;

typedef struct HeaderInfo {
    int width;
    int height;
    int has_alpha;
    int frame_count; // 动画扩展，帧总数
    int repetition_count; // 动画扩展，重播次数
    int x_offset, y_offset;  // 动画扩展，位置信息
    int duration;            // 动画扩展，帧时长
    int decode_lines_offset; // 解码的最小行数。例如 hevc 一次解码的最小输出是 64 行，jepg 一次解码的最小输出为 8 行
    int min_output_len;
    // 待补充
} header_info;
    
    
int hevcd_get_version();

    // for hevc video decode
void*       hevcd_open(hevcd_init_param_t *p, int ahp_opt);
HEVCDStatus hevcd_decode_header(void *s, avpkt_t *pkt, vframeInfo_t *info);
HEVCDStatus hevcd_decode_frame(void *s, avpkt_t *pkt, vframe_t *frm, unsigned int *got_frame, int def_colorspace);
HEVCDStatus hevcd_flush(void *s, avpkt_t *pkt, vframe_t *frm, unsigned int *got_frame);
void 	    hevcd_close(void *s);

   // for image decode
HEVCDStatus hevcd_image_init(void **s, avpkt_t *pkt, vframeInfo_t *info, hevcd_init_param_t* cfg, int ahp_opt);
HEVCDStatus hevcd_image_decode(void *s, vframe_t *frm, int def_colorspace, int ahp_opt);
HEVCDStatus hevcd_image_close(void *s);
HEVCDStatus hevcd_image_ar_decode(void *s, vframe_t *frm, int def_colorspace, int ahp_opt);

// for video decode
HEVCDStatus hevcd_video_init(void **s, avpkt_t *pkt, vframeInfo_t *info, hevcd_init_param_t* cfg, int ahp_opt);
HEVCDStatus hevcd_video_getFrameDelayTimeList(void **s, int frameCnt, int **delayTimeList);
HEVCDStatus hevcd_video_decode(void **s, vframe_t *frm, int def_colorspace, int ahp_opt);
HEVCDStatus hevcd_video_reset(void **s);
HEVCDStatus hevcd_video_close(void **s);

// for decode Ahp3 to YUV420P
HEVCDStatus hevcd_video_decode_to_yuv(void **s, vframe_t *frm, int def_colorspace, int ahp_opt);

// for decode Ahp1/2 to YUV420P
HEVCDStatus hevcd_image_decode_to_yuv(void **s, vframe_t *frm, int def_colorspace, int ahp_opt);
    
//for decode ahp2 progressive
//HEVCDStatus decode_ahp2_data(void *decoder, unsigned char* ps_out_buf, unsigned char* rgbaData); //decode non-sequential ahp data
HEVCDStatus decode_ahp2_data(void *decoder, unsigned char* ps_out_buf, int *pgot_row);    //decode ahp data sequentially
HEVCDStatus pgdecode_ahp2_data(void *decoder, unsigned char* ps_out_buf, int *pgot_row);    //decode ahp data sequentially
HEVCDStatus pgahp2_decoder_open(void **decoder);    
HEVCDStatus pgahp2_decoder_set_data(void* decoder, const unsigned char* data, int data_length, int all_data_recdived);
HEVCDStatus pgdecode_check_ahp_header(void *decoder, header_info* pheaderinfo);
HEVCDStatus pgdecode_ahp2_header(void *decoder, header_info* pheaderinfo);
HEVCDStatus pgdestroy_ahp2_decoder(void *decoder);
    
#ifdef __cplusplus
}
#endif

#endif
