//
//  ahp3_decoder.h
//  descriprion: AHP3 decode API.
//
//  Created by 陈爽 on 2019/09/17.
//  Copyright © 2019 Alipay. All rights reserved.
#ifndef AHP3_DECODER_H
#define AHP3_DECODER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <limits.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "ihevcd_warpper.h"

#define AHP3_PERF_LOG
#ifdef AHP3_PERF_LOG
#include <sys/time.h>
#define AHP3_PERF_TAG "ahp3_perf"
static int64_t ahp3_gettime(void) {
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return (int64_t)tv.tv_sec * 1000000 + tv.tv_usec;
}
#endif  //AHP3_PERF_LOG

typedef enum AHP3_STATUS_Type {
    AHP3_UNKNOWN_ERROR = -500,
    AHP3_INVALID_PARAMS = -105,
    AHP3_EOF = -104,
    AHP3_ONLY_ONE_FRAME = -103,
    AHP3_PARAM_ERROR  = -102,
    AHP3_STATE_ERROR  = -101,
    AHP3_PIXELS_ERROR = -100,
    AHP3_MALLOC_ERROR = -10,
    AHP3_ENCODE_ERROR = -2,
    AHP3_DECODE_ERROR = -3,
    AHP3_DECODE_RESET_ERROR = -4,
    AHP3_IO_ERROR = -1,
    AHP3_SUCCESS = 0,
    AHP3_STOP = 100,
} AHP3_STATUS_Type;

typedef struct ahp3_t {
    void *s;
    vframeInfo_t info;
    avpkt_t pkt;
    vframe_t frm;
    hevcd_init_param_t cfg;
    unsigned char* pu1_bitstream_buf;
    unsigned char* pu1_outyuv_buf;
    unsigned char* pu1_outRGBA_buf;
    unsigned char* pu1_outalpha_buf;
    unsigned long  u4_bitstream_len;
} ahp3_t;

typedef struct Ahp3Decoder {
    int fd;
    int width;
    int height;
    int cur_frame;              // current frame index, start from 0
    int frame_count;            // frame count in Ahp3.
    int loop_count;             // loop count. <0: infinite loop, >0: loop special count, =0: loop 1 time
    char *filename;
    int *frameDelayList;       // delay time of each frame.

    int dec_init;
    ahp3_t ahp3DecCtx;

    uint8_t *data_buffer;
    uint8_t *ps_out_buf;
    uint8_t *ps_RGBA_buf;
    uint8_t *ps_alpha_buf;
} Ahp3Decoder;

typedef struct {
    uint8_t Red;
    uint8_t Green;
    uint8_t Blue;
    uint8_t Alpha;
} ahp3_argb;

int ahp3_init_by_file_buf(Ahp3Decoder **decoder, const char *filename, int loop_count);

int ahp3_init_by_data_buf(Ahp3Decoder **decoder, uint8_t *data_buffer, int buffer_len, int loop_count);

void ahp3_releasep(Ahp3Decoder *decoder);

int ahp3_get_next_frame(Ahp3Decoder *decoder, uint8_t *out_buffer, int loop, int *delay_ms);

int ahp3_get_next_frame_yuv(Ahp3Decoder *decoder, uint8_t *out_buffer, int *delay_ms);

int ahp3_get_width(Ahp3Decoder *decoder);

int ahp3_get_height(Ahp3Decoder *decoder);

int ahp3_draw_frame(Ahp3Decoder *decoder, void *p_bitmap);

int ahp3_reset(Ahp3Decoder *decoder);

#endif
